/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.hsqldbmgr.dom.services;

import javax.annotation.Priority;
import javax.inject.Inject;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.config.datasources.DataSourceIntrospectionService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hsqldb.util.DatabaseManagerSwing;

@DomainService(nature=NatureOfService.VIEW, logicalTypeName="isis.ext.hsqldbMgr.HsqlDbManagerMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
@Priority(value=0x1FFFFFFF)
public class HsqlDbManagerMenu {
    private static final Logger log = LogManager.getLogger(HsqlDbManagerMenu.class);
    public static final String LOGICAL_TYPE_NAME = "isis.ext.hsqldbMgr.HsqlDbManagerMenu";
    private final String url;

    @Inject
    public HsqlDbManagerMenu(DataSourceIntrospectionService datasourceIntrospector) {
        this.url = datasourceIntrospector.getDataSourceInfos().stream().map(DataSourceIntrospectionService.DataSourceInfo::getJdbcUrl).filter(jdbcUrl -> {
            if (jdbcUrl.contains("hsqldb:mem")) {
                log.info("found hsqldb in-memory data-source: {}", jdbcUrl);
                return true;
            }
            return false;
        }).findFirst().orElse(null);
    }

    @Action(semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING, domainEvent=ActionDomainEvent.class)
    @ActionLayout(named="HSQL DB Manager", cssClassFa="database", sequence="500.800")
    public void hsqlDbManager() {
        String[] args = new String[]{"--url", this.url, "--noexit"};
        DatabaseManagerSwing.main((String[])args);
    }

    public boolean hideHsqlDbManager() {
        try {
            _Context.loadClass((String)"org.hsqldb.util.DatabaseManagerSwing");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return true;
        }
        return _Strings.isNullOrEmpty((CharSequence)this.url) || !this.url.contains("hsqldb:mem");
    }

    public static class ActionDomainEvent
    extends IsisModuleApplib.ActionDomainEvent<HsqlDbManagerMenu> {
    }
}

