/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fixtures.applib.fixturescripts;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.isis.testing.fixtures.applib.fixturescripts.ExecutionParameters;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExecutionParameters_Test {
    private ExecutionParameters executionParameters;

    @BeforeEach
    public void setUp() throws Exception {
        this.executionParameters = new ExecutionParameters("");
    }

    @Test
    public void roundTripByte() throws Exception {
        int value = 3;
        this.executionParameters.setParameter("test", Byte.valueOf((byte)3));
        byte roundTripped = this.executionParameters.getParameterAsByte("test");
        byte roundTrippedAsT = (Byte)this.executionParameters.getParameterAsT("test", Byte.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void roundTripShort() throws Exception {
        int value = 323;
        this.executionParameters.setParameter("test", Short.valueOf((short)323));
        short roundTripped = this.executionParameters.getParameterAsShort("test");
        short roundTrippedAsT = (Short)this.executionParameters.getParameterAsT("test", Short.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)323));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)323));
    }

    @Test
    public void roundTripInteger() throws Exception {
        int value = 32323;
        this.executionParameters.setParameter("test", Integer.valueOf(32323));
        int roundTripped = this.executionParameters.getParameterAsInteger("test");
        int roundTrippedAsT = (Integer)this.executionParameters.getParameterAsT("test", Integer.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)32323));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)32323));
    }

    @Test
    public void roundTripLong() throws Exception {
        long value = 323232323L;
        this.executionParameters.setParameter("test", Long.valueOf(323232323L));
        long roundTripped = this.executionParameters.getParameterAsLong("test");
        long roundTrippedAsT = (Long)this.executionParameters.getParameterAsT("test", Long.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)323232323L));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)323232323L));
    }

    @Test
    public void roundTripFloat() throws Exception {
        float value = 3.2323232E8f;
        this.executionParameters.setParameter("test", Float.valueOf(3.2323232E8f));
        float roundTripped = this.executionParameters.getParameterAsFloat("test").floatValue();
        float roundTrippedAsT = ((Float)this.executionParameters.getParameterAsT("test", Float.class)).floatValue();
        MatcherAssert.assertThat((Object)Float.valueOf(roundTripped), (Matcher)CoreMatchers.is((Object)Float.valueOf(3.2323232E8f)));
        MatcherAssert.assertThat((Object)Float.valueOf(roundTrippedAsT), (Matcher)CoreMatchers.is((Object)Float.valueOf(3.2323232E8f)));
    }

    @Test
    public void roundTripDouble() throws Exception {
        double value = 3.232323231232323E11;
        this.executionParameters.setParameter("test", Double.valueOf(3.232323231232323E11));
        double roundTripped = this.executionParameters.getParameterAsDouble("test");
        double roundTrippedAsT = (Double)this.executionParameters.getParameterAsT("test", Double.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)3.232323231232323E11));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)3.232323231232323E11));
    }

    @Test
    public void roundTripCharacter() throws Exception {
        int value = 120;
        this.executionParameters.setParameter("test", Character.valueOf('x'));
        char roundTripped = this.executionParameters.getParameterAsCharacter("test").charValue();
        char roundTrippedAsT = ((Character)this.executionParameters.getParameterAsT("test", Character.class)).charValue();
        MatcherAssert.assertThat((Object)Character.valueOf(roundTripped), (Matcher)CoreMatchers.is((Object)Character.valueOf('x')));
        MatcherAssert.assertThat((Object)Character.valueOf(roundTrippedAsT), (Matcher)CoreMatchers.is((Object)Character.valueOf('x')));
    }

    @Test
    public void roundTripString() throws Exception {
        String value = "Hello World!";
        this.executionParameters.setParameter("test", "Hello World!");
        String roundTripped = this.executionParameters.getParameter("test");
        String roundTrippedAsT = (String)this.executionParameters.getParameterAsT("test", String.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)"Hello World!"));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)"Hello World!"));
    }

    @Test
    public void roundTripBoolean() throws Exception {
        boolean value = true;
        this.executionParameters.setParameter("test", Boolean.valueOf(true));
        boolean roundTripped = this.executionParameters.getParameterAsBoolean("test");
        boolean roundTrippedAsT = (Boolean)this.executionParameters.getParameterAsT("test", Boolean.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void roundTripBigDecimal() throws Exception {
        BigDecimal value = new BigDecimal("123456.789123456789");
        this.executionParameters.setParameter("test", value);
        BigDecimal roundTripped = this.executionParameters.getParameterAsBigDecimal("test");
        BigDecimal roundTrippedAsT = (BigDecimal)this.executionParameters.getParameterAsT("test", BigDecimal.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)value));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void roundTripBigInteger() throws Exception {
        BigInteger value = new BigInteger("123456789123456789");
        this.executionParameters.setParameter("test", value);
        BigInteger roundTripped = this.executionParameters.getParameterAsBigInteger("test");
        BigInteger roundTrippedAsT = (BigInteger)this.executionParameters.getParameterAsT("test", BigInteger.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)value));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void roundTripLocalDate() throws Exception {
        LocalDate value = LocalDate.now();
        this.executionParameters.setParameter("test", value);
        LocalDate roundTripped = this.executionParameters.getParameterAsLocalDate("test");
        LocalDate roundTrippedAsT = (LocalDate)this.executionParameters.getParameterAsT("test", LocalDate.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)value));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void roundTripLocalDateTime() throws Exception {
        LocalDateTime value = LocalDateTime.now();
        this.executionParameters.setParameter("test", value);
        LocalDateTime roundTripped = this.executionParameters.getParameterAsLocalDateTime("test");
        LocalDateTime roundTrippedAsT = (LocalDateTime)this.executionParameters.getParameterAsT("test", LocalDateTime.class);
        MatcherAssert.assertThat((Object)roundTripped, (Matcher)CoreMatchers.is((Object)value));
        MatcherAssert.assertThat((Object)roundTrippedAsT, (Matcher)CoreMatchers.is((Object)value));
    }

    @Test
    public void roundTripEnum() throws Exception {
        EnumForTest value = EnumForTest.hello;
        this.executionParameters.setParameter("test", (Enum)value);
        EnumForTest roundTripped = (EnumForTest)this.executionParameters.getParameterAsEnum("test", EnumForTest.class);
        EnumForTest roundTrippedAsT = (EnumForTest)((Object)this.executionParameters.getParameterAsT("test", EnumForTest.class));
        MatcherAssert.assertThat((Object)((Object)roundTripped), (Matcher)CoreMatchers.is((Object)((Object)value)));
        MatcherAssert.assertThat((Object)((Object)roundTrippedAsT), (Matcher)CoreMatchers.is((Object)((Object)value)));
    }

    private static enum EnumForTest {
        hello,
        world;

    }
}

