/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fixtures.applib.fixturescripts;

import java.util.Map;
import org.apache.isis.testing.fixtures.applib.fixturescripts.ExecutionContextTest;
import org.apache.isis.testing.fixtures.applib.fixturescripts.ExecutionParameters;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class ExecutionParameters_AsKeyValueMap_Test
extends ExecutionContextTest {
    @Test
    public void happyCase() throws Exception {
        Map map = ExecutionParameters.asKeyValueMap((String)"foo=bar\nbop=baz");
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(map.get("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
        MatcherAssert.assertThat(map.get("bop"), (Matcher)CoreMatchers.is((Object)"baz"));
    }

    @Test
    public void givenNull() throws Exception {
        Map map = ExecutionParameters.asKeyValueMap(null);
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void givenEmpty() throws Exception {
        Map map = ExecutionParameters.asKeyValueMap((String)"");
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void trim() throws Exception {
        Map map = ExecutionParameters.asKeyValueMap((String)" foo=bar\nbop=baz \n bip = bap ");
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(map.get("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
        MatcherAssert.assertThat(map.get("bop"), (Matcher)CoreMatchers.is((Object)"baz"));
        MatcherAssert.assertThat(map.get("bip"), (Matcher)CoreMatchers.is((Object)"bap"));
    }

    @Test
    public void malformed() throws Exception {
        Map map = ExecutionParameters.asKeyValueMap((String)"abcde");
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void partiallyMalformed() throws Exception {
        Map map = ExecutionParameters.asKeyValueMap((String)"foo=bar\nabcde\nbop=baz");
        MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(map.get("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
        MatcherAssert.assertThat(map.get("bop"), (Matcher)CoreMatchers.is((Object)"baz"));
    }
}

