/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fixtures.applib.fixturescripts;

import java.util.Map;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScript;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class ExecutionContextTest {

    public static class SetParameterIfNotPresent
    extends ExecutionContextTest {
        @Test
        public void whenNotPresent() throws Exception {
            FixtureScript.ExecutionContext executionContext = new FixtureScript.ExecutionContext((String)null, null);
            executionContext.setParameterIfNotPresent("foo", "bar");
            MatcherAssert.assertThat((Object)executionContext.getParameter("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
        }

        @Test
        public void whenPresent() throws Exception {
            FixtureScript.ExecutionContext executionContext = new FixtureScript.ExecutionContext("foo=bop\n", null);
            executionContext.setParameterIfNotPresent("foo", "bar");
            MatcherAssert.assertThat((Object)executionContext.getParameter("foo"), (Matcher)CoreMatchers.is((Object)"bop"));
        }
    }

    public static class GetParameter
    extends ExecutionContextTest {
        @Test
        public void happyCase() throws Exception {
            FixtureScript.ExecutionContext executionContext = new FixtureScript.ExecutionContext("foo=bar\nbop=baz", null);
            Map map = executionContext.getParameterMap();
            MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)2));
            MatcherAssert.assertThat(map.get("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
            MatcherAssert.assertThat(map.get("bop"), (Matcher)CoreMatchers.is((Object)"baz"));
            MatcherAssert.assertThat((Object)executionContext.getParameter("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
            MatcherAssert.assertThat((Object)executionContext.getParameter("bop"), (Matcher)CoreMatchers.is((Object)"baz"));
        }

        @Test
        public void givenNull() throws Exception {
            FixtureScript.ExecutionContext executionContext = new FixtureScript.ExecutionContext((String)null, null);
            Map map = executionContext.getParameterMap();
            MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)0));
            MatcherAssert.assertThat((Object)executionContext.getParameter("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }

        @Test
        public void givenEmpty() throws Exception {
            FixtureScript.ExecutionContext executionContext = new FixtureScript.ExecutionContext("", null);
            Map map = executionContext.getParameterMap();
            MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)0));
            MatcherAssert.assertThat((Object)executionContext.getParameter("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }

        @Test
        public void malformed() throws Exception {
            FixtureScript.ExecutionContext executionContext = new FixtureScript.ExecutionContext("abcde", null);
            Map map = executionContext.getParameterMap();
            MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)0));
            MatcherAssert.assertThat((Object)executionContext.getParameter("foo"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }

        @Test
        public void partiallyMalformed() throws Exception {
            FixtureScript.ExecutionContext executionContext = new FixtureScript.ExecutionContext("foo=bar\nabcde\nbop=baz", null);
            Map map = executionContext.getParameterMap();
            MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)2));
            MatcherAssert.assertThat(map.get("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
            MatcherAssert.assertThat(map.get("bop"), (Matcher)CoreMatchers.is((Object)"baz"));
            MatcherAssert.assertThat((Object)executionContext.getParameter("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
            MatcherAssert.assertThat((Object)executionContext.getParameter("bop"), (Matcher)CoreMatchers.is((Object)"baz"));
        }

        @Test
        public void trim() throws Exception {
            FixtureScript.ExecutionContext executionContext = new FixtureScript.ExecutionContext(" foo=bar\nbop=baz \n bip = bap ", null);
            Map map = executionContext.getParameterMap();
            MatcherAssert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)3));
            MatcherAssert.assertThat(map.get("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
            MatcherAssert.assertThat(map.get("bop"), (Matcher)CoreMatchers.is((Object)"baz"));
            MatcherAssert.assertThat(map.get("bip"), (Matcher)CoreMatchers.is((Object)"bap"));
            MatcherAssert.assertThat((Object)executionContext.getParameter("foo"), (Matcher)CoreMatchers.is((Object)"bar"));
            MatcherAssert.assertThat((Object)executionContext.getParameter("bop"), (Matcher)CoreMatchers.is((Object)"baz"));
            MatcherAssert.assertThat((Object)executionContext.getParameter("bip"), (Matcher)CoreMatchers.is((Object)"bap"));
        }
    }
}

