/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.subdomains.spring.applib.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public final class BeanDescriptor {
    private static final Logger log = LogManager.getLogger(BeanDescriptor.class);
    private final String beanName;
    private final List<String> aliases;
    private final String scope;
    private final Class<?> type;
    private final String resource;
    private final Map<String, BeanNameAndDescriptor> dependenciesByName;

    BeanDescriptor(String beanName, ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        this.beanName = beanName;
        BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
        this.aliases = Collections.unmodifiableList(Arrays.asList(beanFactory.getAliases(beanName)));
        String scope = definition.getScope();
        this.scope = StringUtils.hasText((String)scope) ? scope : "singleton";
        this.type = beanFactory.getType(beanName);
        this.resource = definition.getResourceDescription();
        Object[] dependencies = beanFactory.getDependenciesForBean(beanName);
        this.dependenciesByName = _NullSafe.stream((Object[])dependencies).map(name -> {
            try {
                return BeanNameAndDescriptor.of(name, beanFactory.getBeanDefinition(name), (BeanFactory)beanFactory);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(BeanNameAndDescriptor::getBeanName, Function.identity()));
    }

    <T> List<T> dependencies(Class<T> cls) {
        log.warn("non optimzed implementation: creates a bean for each dependency, even if not returned with the result");
        return this.dependenciesByName.values().stream().map(BeanNameAndDescriptor::getBean).filter(cls::isInstance).map(cls::cast).collect(Collectors.toList());
    }

    public String getBeanName() {
        return this.beanName;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getScope() {
        return this.scope;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getResource() {
        return this.resource;
    }

    public Map<String, BeanNameAndDescriptor> getDependenciesByName() {
        return this.dependenciesByName;
    }

    public String toString() {
        return "BeanDescriptor(beanName=" + this.getBeanName() + ", aliases=" + this.getAliases() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", resource=" + this.getResource() + ", dependenciesByName=" + this.getDependenciesByName() + ")";
    }

    private static final class BeanNameAndDescriptor {
        private final String beanName;
        private final BeanDefinition beanDefinition;
        private final BeanFactory beanFactory;

        Object getBean() {
            return this.beanFactory.getBean(this.beanName);
        }

        private BeanNameAndDescriptor(String beanName, BeanDefinition beanDefinition, BeanFactory beanFactory) {
            this.beanName = beanName;
            this.beanDefinition = beanDefinition;
            this.beanFactory = beanFactory;
        }

        public static BeanNameAndDescriptor of(String beanName, BeanDefinition beanDefinition, BeanFactory beanFactory) {
            return new BeanNameAndDescriptor(beanName, beanDefinition, beanFactory);
        }

        public String getBeanName() {
            return this.beanName;
        }

        public BeanDefinition getBeanDefinition() {
            return this.beanDefinition;
        }

        public BeanFactory getBeanFactory() {
            return this.beanFactory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BeanNameAndDescriptor)) {
                return false;
            }
            BeanNameAndDescriptor other = (BeanNameAndDescriptor)o;
            String this$beanName = this.getBeanName();
            String other$beanName = other.getBeanName();
            if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
                return false;
            }
            BeanDefinition this$beanDefinition = this.getBeanDefinition();
            BeanDefinition other$beanDefinition = other.getBeanDefinition();
            if (this$beanDefinition == null ? other$beanDefinition != null : !this$beanDefinition.equals(other$beanDefinition)) {
                return false;
            }
            BeanFactory this$beanFactory = this.getBeanFactory();
            BeanFactory other$beanFactory = other.getBeanFactory();
            return !(this$beanFactory == null ? other$beanFactory != null : !this$beanFactory.equals(other$beanFactory));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $beanName = this.getBeanName();
            result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
            BeanDefinition $beanDefinition = this.getBeanDefinition();
            result = result * 59 + ($beanDefinition == null ? 43 : $beanDefinition.hashCode());
            BeanFactory $beanFactory = this.getBeanFactory();
            result = result * 59 + ($beanFactory == null ? 43 : $beanFactory.hashCode());
            return result;
        }

        public String toString() {
            return "BeanDescriptor.BeanNameAndDescriptor(beanName=" + this.getBeanName() + ", beanDefinition=" + this.getBeanDefinition() + ", beanFactory=" + this.getBeanFactory() + ")";
        }
    }
}

