/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.embedded.dom.claim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.AbstractDomainObject;
import org.apache.isis.applib.annotation.Disabled;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.value.Color;
import org.apache.isis.applib.value.Date;
import org.apache.isis.runtimes.embedded.dom.claim.Approver;
import org.apache.isis.runtimes.embedded.dom.claim.ClaimItem;
import org.apache.isis.runtimes.embedded.dom.claim.Claimant;

public class Claim
extends AbstractDomainObject {
    private String description;
    private Date date;
    private String status;
    private Claimant claimant;
    private BigDecimal bigDecimal;
    private Color color;
    private Approver approver;
    private final List<ClaimItem> items = new ArrayList<ClaimItem>();

    public String title() {
        return this.getStatus() + " - " + this.getDate();
    }

    public void created() {
        this.status = "New";
        this.date = new Date();
    }

    @MemberOrder(sequence="1")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String defaultDescription() {
        return "enter a description here";
    }

    @MemberOrder(sequence="2")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Disabled
    @MemberOrder(sequence="3")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Disabled
    @MemberOrder(sequence="4")
    public Claimant getClaimant() {
        return this.claimant;
    }

    public void setClaimant(Claimant claimant) {
        this.claimant = claimant;
    }

    @MemberOrder(sequence="9")
    public BigDecimal getBigDecimal() {
        return this.bigDecimal;
    }

    public void setBigDecimal(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
    }

    public void modifyBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.equals(this.getBigDecimal())) {
            return;
        }
        this.setBigDecimal(bigDecimal);
        this.onModifyBigDecimal(bigDecimal);
    }

    public void clearBigDecimal() {
        if (this.getBigDecimal() == null) {
            return;
        }
        this.setBigDecimal(null);
        this.onClearBigDecimal();
    }

    protected void onModifyBigDecimal(BigDecimal bigDecimal) {
    }

    protected void onClearBigDecimal() {
    }

    @MemberOrder(sequence="8")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void modifyColor(Color color) {
        if (color == null || color.equals((Object)this.getColor())) {
            return;
        }
        this.setColor(color);
        this.onModifyColor(color);
    }

    public void clearColor() {
        if (this.getColor() == null) {
            return;
        }
        this.setColor(null);
        this.onClearColor();
    }

    protected void onModifyColor(Color color) {
    }

    protected void onClearColor() {
    }

    @Disabled
    @MemberOrder(sequence="5")
    public Approver getApprover() {
        return this.approver;
    }

    public void setApprover(Approver approver) {
        this.approver = approver;
    }

    @MemberOrder(sequence="6")
    public List<ClaimItem> getItems() {
        return this.items;
    }

    public void addToItems(ClaimItem item) {
        this.items.add(item);
    }

    public void submit(Approver approver) {
        this.setStatus("Submitted");
        this.setApprover(approver);
    }

    public String disableSubmit() {
        return this.getStatus().equals("New") ? null : "Claim has already been submitted";
    }

    public Object[] defaultSubmit() {
        return new Object[]{this.getClaimant().getApprover()};
    }
}

