/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.embedded;

import java.util.TreeSet;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetdecorator.FacetDecorator;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.runtimes.embedded.EmbeddedContext;
import org.apache.isis.runtimes.embedded.IsisMetaModel;
import org.apache.isis.runtimes.embedded.dom.claim.ClaimRepositoryImpl;
import org.apache.isis.runtimes.embedded.dom.employee.EmployeeRepositoryImpl;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class GivenMetaModelWhenShutdown {
    private final Mockery mockery = new JUnit4Mockery();
    private IsisConfiguration mockConfiguration;
    private ProgrammingModel mockProgrammingModelFacets;
    private FacetDecorator mockFacetDecorator;
    private ClassSubstitutor mockClassSubstitutor;
    private CollectionTypeRegistry mockCollectionTypeRegistry;
    private EmbeddedContext mockContext;
    private IsisMetaModel metaModel;

    @Before
    public void setUp() {
        this.mockContext = (EmbeddedContext)this.mockery.mock(EmbeddedContext.class);
        this.mockConfiguration = (IsisConfiguration)this.mockery.mock(IsisConfiguration.class);
        this.mockProgrammingModelFacets = (ProgrammingModel)this.mockery.mock(ProgrammingModel.class);
        this.mockCollectionTypeRegistry = (CollectionTypeRegistry)this.mockery.mock(CollectionTypeRegistry.class);
        this.mockFacetDecorator = (FacetDecorator)this.mockery.mock(FacetDecorator.class);
        this.mockClassSubstitutor = (ClassSubstitutor)this.mockery.mock(ClassSubstitutor.class);
        this.metaModel = new IsisMetaModel(this.mockContext, new Class[]{EmployeeRepositoryImpl.class, ClaimRepositoryImpl.class});
    }

    @Test
    public void shouldSucceedWithoutThrowingAnyExceptions() {
        this.metaModel.init();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeConfiguration() {
        this.metaModel.init();
        this.metaModel.setConfiguration(this.mockConfiguration);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeProgrammingModelFacets() {
        this.metaModel.init();
        this.metaModel.setProgrammingModelFacets(this.mockProgrammingModelFacets);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeCollectionTypeRegistry() {
        this.metaModel.init();
        this.metaModel.setCollectionTypeRegistry(this.mockCollectionTypeRegistry);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeClassSubstitutor() {
        this.metaModel.init();
        this.metaModel.setClassSubstitutor(this.mockClassSubstitutor);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToChangeFacetDecorators() {
        this.metaModel.init();
        this.metaModel.setFacetDecorators(new TreeSet());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotBeAbleToAddToFacetDecorators() {
        this.metaModel.init();
        this.metaModel.getFacetDecorators().add(this.mockFacetDecorator);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToInitializeAgain() {
        this.metaModel.init();
        this.metaModel.init();
    }
}

