/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.embedded;

import org.apache.isis.runtimes.embedded.EmbeddedContext;
import org.apache.isis.runtimes.embedded.IsisMetaModel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class GivenMetaModelWhenInstantiated {
    private final Mockery mockery = new JUnit4Mockery();
    private EmbeddedContext mockContext;
    private IsisMetaModel metaModel;

    @Before
    public void setUp() {
        this.mockContext = (EmbeddedContext)this.mockery.mock(EmbeddedContext.class);
        this.metaModel = new IsisMetaModel(this.mockContext, new Class[0]);
    }

    @Test
    public void shouldDefaultConfiguration() {
        Assert.assertThat((Object)this.metaModel.getConfiguration(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldDefaultClassSubstitutor() {
        Assert.assertThat((Object)this.metaModel.getClassSubstitutor(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldDefaultProgrammingModelFacets() {
        Assert.assertThat((Object)this.metaModel.getProgrammingModelFacets(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldDefaultCollectionTypeRegistry() {
        Assert.assertThat((Object)this.metaModel.getCollectionTypeRegistry(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldDefaultFacetDecorators() {
        Assert.assertThat((Object)this.metaModel.getFacetDecorators(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldHaveNoFacetDecorators() {
        Assert.assertThat((Object)this.metaModel.getFacetDecorators().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotBeAbleToShutdown() {
        this.metaModel.shutdown();
    }
}

