/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.embedded;

import java.util.List;
import org.apache.isis.runtimes.embedded.EmbeddedContext;
import org.apache.isis.runtimes.embedded.IsisMetaModel;
import org.apache.isis.runtimes.embedded.dom.claim.ClaimRepositoryImpl;
import org.apache.isis.runtimes.embedded.dom.employee.EmployeeRepositoryImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class GivenMetaModelWhenInstantiate {
    private final Mockery mockery = new JUnit4Mockery();
    private EmbeddedContext mockContext;
    private IsisMetaModel metaModel;

    @Before
    public void setUp() {
        this.mockContext = (EmbeddedContext)this.mockery.mock(EmbeddedContext.class);
    }

    @Test
    public void shouldSucceedWithoutThrowingAnyExceptions() {
        this.metaModel = new IsisMetaModel(this.mockContext, new Class[0]);
    }

    @Test
    public void shouldBeAbleToRegisterServices() {
        this.metaModel = new IsisMetaModel(this.mockContext, new Class[]{EmployeeRepositoryImpl.class, ClaimRepositoryImpl.class});
        List serviceTypes = this.metaModel.getServiceTypes();
        Assert.assertThat((Object)serviceTypes.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)serviceTypes.contains(EmployeeRepositoryImpl.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)serviceTypes.contains(ClaimRepositoryImpl.class), (Matcher)CoreMatchers.is((Object)true));
    }
}

