/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.scalar;

import java.util.List;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.scalars.WrapperValuedEntity;
import org.apache.isis.core.tck.dom.scalars.WrapperValuedEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persistAndUpdate_wrapperValuedEntity {
    private WrapperValuedEntityRepository repo = new WrapperValuedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("WRAPPERVALUEDENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void persistTwo() throws Exception {
        this.iswf.beginTran();
        this.repo.newEntity().setStringProperty("1");
        this.repo.newEntity().setStringProperty("2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void persist_then_update() throws Exception {
        this.iswf.beginTran();
        WrapperValuedEntity entity = this.repo.newEntity();
        entity.setStringProperty("1");
        entity.setBooleanProperty(Boolean.valueOf(false));
        entity.setByteProperty(Byte.valueOf((byte)65));
        entity.setDoubleProperty(Double.valueOf(1.23456768723429E14));
        entity.setFloatProperty(Float.valueOf(654321.0f));
        entity.setIntegerProperty(Integer.valueOf(543));
        entity.setLongProperty(Long.valueOf(90876512345L));
        entity.setShortProperty(Short.valueOf((short)7654));
        entity.setCharacterProperty(Character.valueOf('A'));
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (WrapperValuedEntity)this.repo.list().get(0);
        Assert.assertThat((Object)entity.getStringProperty(), (Matcher)CoreMatchers.is((Object)"1"));
        Assert.assertThat((Object)entity.getBooleanProperty(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)entity.getByteProperty(), (Matcher)CoreMatchers.is((Object)65));
        Assert.assertThat((Object)entity.getDoubleProperty(), (Matcher)CoreMatchers.is((Object)1.23456768723429E14));
        Assert.assertThat((Object)entity.getFloatProperty(), (Matcher)CoreMatchers.is((Object)Float.valueOf(654321.0f)));
        Assert.assertThat((Object)entity.getIntegerProperty(), (Matcher)CoreMatchers.is((Object)543));
        Assert.assertThat((Object)entity.getLongProperty(), (Matcher)CoreMatchers.is((Object)90876512345L));
        Assert.assertThat((Object)entity.getShortProperty(), (Matcher)CoreMatchers.is((Object)7654));
        Assert.assertThat((Object)entity.getCharacterProperty(), (Matcher)CoreMatchers.is((Object)Character.valueOf('A')));
        entity.setBooleanProperty(Boolean.valueOf(true));
        entity.setByteProperty(Byte.valueOf((byte)123));
        entity.setDoubleProperty(Double.valueOf(9.876543210987E12));
        entity.setFloatProperty(Float.valueOf(123456.0f));
        entity.setIntegerProperty(Integer.valueOf(456));
        entity.setLongProperty(Long.valueOf(12345678901L));
        entity.setShortProperty(Short.valueOf((short)4567));
        entity.setCharacterProperty(Character.valueOf('X'));
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (WrapperValuedEntity)this.repo.list().get(0);
        Assert.assertThat((Object)entity.getBooleanProperty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entity.getByteProperty(), (Matcher)CoreMatchers.is((Object)123));
        Assert.assertThat((Object)entity.getDoubleProperty(), (Matcher)CoreMatchers.is((Object)9.876543210987E12));
        Assert.assertThat((Object)entity.getFloatProperty(), (Matcher)CoreMatchers.is((Object)Float.valueOf(123456.0f)));
        Assert.assertThat((Object)entity.getIntegerProperty(), (Matcher)CoreMatchers.is((Object)456));
        Assert.assertThat((Object)entity.getLongProperty(), (Matcher)CoreMatchers.is((Object)12345678901L));
        Assert.assertThat((Object)entity.getShortProperty(), (Matcher)CoreMatchers.is((Object)4567));
        Assert.assertThat((Object)entity.getCharacterProperty(), (Matcher)CoreMatchers.is((Object)Character.valueOf('X')));
        this.iswf.commitTran();
    }
}

