/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.scalar;

import java.util.List;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntity;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persistAndUpdate_primitiveValuedEntity {
    private PrimitiveValuedEntityRepository repo = new PrimitiveValuedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("PRIMITIVEVALUEDENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void persistTwo() throws Exception {
        this.iswf.beginTran();
        ((PrimitiveValuedEntity)this.repo.newEntity()).setId(Integer.valueOf(1));
        ((PrimitiveValuedEntity)this.repo.newEntity()).setId(Integer.valueOf(2));
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void persist_then_update() throws Exception {
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = (PrimitiveValuedEntity)this.repo.newEntity();
        entity.setId(Integer.valueOf(1));
        entity.setBooleanProperty(false);
        entity.setByteProperty((byte)-56);
        entity.setDoubleProperty(1.23456789876E11);
        entity.setFloatProperty(654321.0f);
        entity.setIntProperty(765);
        entity.setLongProperty(7654321012345L);
        entity.setShortProperty((short)543);
        entity.setCharProperty('A');
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (PrimitiveValuedEntity)this.repo.list().get(0);
        Assert.assertThat((Object)entity.getBooleanProperty(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)entity.getByteProperty(), (Matcher)CoreMatchers.is((Object)-56));
        Assert.assertThat((Object)entity.getDoubleProperty(), (Matcher)CoreMatchers.is((Object)1.23456789876E11));
        Assert.assertThat((Object)Float.valueOf(entity.getFloatProperty()), (Matcher)CoreMatchers.is((Object)Float.valueOf(654321.0f)));
        Assert.assertThat((Object)entity.getIntProperty(), (Matcher)CoreMatchers.is((Object)765));
        Assert.assertThat((Object)entity.getLongProperty(), (Matcher)CoreMatchers.is((Object)7654321012345L));
        Assert.assertThat((Object)entity.getShortProperty(), (Matcher)CoreMatchers.is((Object)543));
        Assert.assertThat((Object)Character.valueOf(entity.getCharProperty()), (Matcher)CoreMatchers.is((Object)Character.valueOf('A')));
        entity.setBooleanProperty(true);
        entity.setByteProperty((byte)123);
        entity.setDoubleProperty(9.876543210987E12);
        entity.setFloatProperty(123456.0f);
        entity.setIntProperty(456);
        entity.setLongProperty(12345678901L);
        entity.setShortProperty((short)4567);
        entity.setCharProperty('X');
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (PrimitiveValuedEntity)this.repo.list().get(0);
        Assert.assertThat((Object)entity.getBooleanProperty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)entity.getByteProperty(), (Matcher)CoreMatchers.is((Object)123));
        Assert.assertThat((Object)entity.getDoubleProperty(), (Matcher)CoreMatchers.is((Object)9.876543210987E12));
        Assert.assertThat((Object)Float.valueOf(entity.getFloatProperty()), (Matcher)CoreMatchers.is((Object)Float.valueOf(123456.0f)));
        Assert.assertThat((Object)entity.getIntProperty(), (Matcher)CoreMatchers.is((Object)456));
        Assert.assertThat((Object)entity.getLongProperty(), (Matcher)CoreMatchers.is((Object)12345678901L));
        Assert.assertThat((Object)entity.getShortProperty(), (Matcher)CoreMatchers.is((Object)4567));
        Assert.assertThat((Object)Character.valueOf(entity.getCharProperty()), (Matcher)CoreMatchers.is((Object)Character.valueOf('X')));
        this.iswf.commitTran();
    }
}

