/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.scalar;

import java.util.List;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntity;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persistAndUpdate_objectAdapters {
    private PrimitiveValuedEntityRepository repo = new PrimitiveValuedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("PRIMITIVEVALUEDENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void transient_then_persistent() throws Exception {
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = (PrimitiveValuedEntity)this.repo.newEntity();
        ObjectAdapter adapter = this.iswf.adapterFor((Object)entity);
        Assert.assertThat((Object)adapter.isTransient(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)adapter.getResolveState(), (Matcher)CoreMatchers.is((Object)ResolveState.TRANSIENT));
        Assert.assertThat((Object)adapter.getOid().isTransient(), (Matcher)CoreMatchers.is((Object)true));
        entity.setId(Integer.valueOf(1));
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
        adapter = this.iswf.adapterFor(list.get(0));
        Assert.assertThat((Object)adapter.getResolveState(), (Matcher)CoreMatchers.is((Object)ResolveState.RESOLVED));
        Assert.assertThat((Object)adapter.isTransient(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)adapter.getOid().enString(new OidMarshaller()), (Matcher)CoreMatchers.is((Object)"PRMV:i~1"));
        this.iswf.commitTran();
    }

    @Test
    public void updated_and_retrieved() throws Exception {
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = (PrimitiveValuedEntity)this.repo.newEntity();
        ObjectAdapter adapter = this.iswf.adapterFor((Object)entity);
        entity.setId(Integer.valueOf(1));
        entity.setCharProperty('X');
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (PrimitiveValuedEntity)this.repo.list().get(0);
        entity.setCharProperty('Y');
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (PrimitiveValuedEntity)this.repo.list().get(0);
        Assert.assertThat((Object)Character.valueOf(entity.getCharProperty()), (Matcher)CoreMatchers.is((Object)Character.valueOf('Y')));
        adapter = this.iswf.adapterFor((Object)entity);
        Assert.assertThat((Object)adapter.getResolveState(), (Matcher)CoreMatchers.is((Object)ResolveState.RESOLVED));
        this.iswf.commitTran();
    }
}

