/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.scalar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.scalars.JdkValuedEntity;
import org.apache.isis.core.tck.dom.scalars.JdkValuedEntityRepository;
import org.apache.isis.core.tck.dom.scalars.MyEnum;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persistAndUpdate_jdkValuedEntity {
    private JdkValuedEntityRepository repo = new JdkValuedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("JDKVALUEDENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void persistTwo() throws Exception {
        this.iswf.beginTran();
        this.repo.newEntity().setStringProperty("1");
        this.repo.newEntity().setStringProperty("2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void persist_then_update() throws Exception {
        this.iswf.beginTran();
        JdkValuedEntity entity = this.repo.newEntity();
        entity.setStringProperty("1");
        entity.setBigDecimalProperty(BigDecimal.valueOf(543210987654321L, 0));
        entity.setBigIntegerProperty(BigInteger.valueOf(123456789012345L));
        entity.setJavaSqlDateProperty(new java.sql.Date(Utils.toMillis(2009, 6, 11)));
        entity.setJavaSqlTimeProperty(new Time(Utils.toMillis(1970, 1, 1, 0, 5, 10)));
        entity.setJavaSqlTimestampProperty(new Timestamp(Utils.toMillis(2010, 5, 13, 20, 25, 30)));
        entity.setJavaUtilDateProperty(new Date(Utils.toMillis(2010, 5, 13, 22, 17, 12)));
        entity.setMyEnum(MyEnum.GREEN);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (JdkValuedEntity)this.repo.list().get(0);
        Assert.assertThat((Object)entity.getStringProperty(), (Matcher)CoreMatchers.is((Object)"1"));
        Assert.assertThat((Object)entity.getBigDecimalProperty(), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(543210987654321L, 0)));
        Assert.assertThat((Object)entity.getBigIntegerProperty(), (Matcher)CoreMatchers.is((Object)BigInteger.valueOf(123456789012345L)));
        Assert.assertThat((Object)entity.getJavaSqlDateProperty(), (Matcher)CoreMatchers.is((Object)new java.sql.Date(Utils.toMillis(2009, 6, 11))));
        Assert.assertThat((Object)entity.getJavaSqlTimeProperty(), (Matcher)CoreMatchers.is((Object)new Time(Utils.toMillis(1970, 1, 1, 0, 5, 10))));
        Assert.assertThat((Object)entity.getJavaSqlTimestampProperty(), (Matcher)CoreMatchers.is((Object)new Timestamp(Utils.toMillis(2010, 5, 13, 20, 25, 30))));
        Assert.assertThat((Object)entity.getJavaUtilDateProperty(), (Matcher)CoreMatchers.is((Object)new Date(Utils.toMillis(2010, 5, 13, 22, 17, 12))));
        Assert.assertThat((Object)entity.getMyEnum(), (Matcher)CoreMatchers.is((Object)MyEnum.GREEN));
        entity.setBigDecimalProperty(BigDecimal.valueOf(123456789012345L, 0));
        entity.setBigIntegerProperty(BigInteger.valueOf(543210987654321L));
        entity.setJavaSqlDateProperty(new java.sql.Date(Utils.toMillis(2010, 5, 13)));
        entity.setJavaSqlTimeProperty(new Time(Utils.toMillis(1970, 1, 1, 5, 10, 15)));
        entity.setJavaSqlTimestampProperty(new Timestamp(Utils.toMillis(2010, 5, 13, 10, 15, 20)));
        entity.setJavaUtilDateProperty(new Date(Utils.toMillis(2010, 5, 13, 20, 15, 10)));
        entity.setMyEnum(MyEnum.BLUE);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (JdkValuedEntity)this.repo.list().get(0);
        Assert.assertThat((Object)entity.getBigDecimalProperty(), (Matcher)CoreMatchers.is((Object)BigDecimal.valueOf(123456789012345L, 0)));
        Assert.assertThat((Object)entity.getBigIntegerProperty(), (Matcher)CoreMatchers.is((Object)BigInteger.valueOf(543210987654321L)));
        Assert.assertThat((Object)entity.getJavaSqlDateProperty(), (Matcher)CoreMatchers.is((Object)new java.sql.Date(Utils.toMillis(2010, 5, 13))));
        Assert.assertThat((Object)entity.getJavaSqlTimeProperty(), (Matcher)CoreMatchers.is((Object)new Time(Utils.toMillis(1970, 1, 1, 5, 10, 15))));
        Assert.assertThat((Object)entity.getJavaSqlTimestampProperty(), (Matcher)CoreMatchers.is((Object)new Timestamp(Utils.toMillis(2010, 5, 13, 10, 15, 20))));
        Assert.assertThat((Object)entity.getJavaUtilDateProperty(), (Matcher)CoreMatchers.is((Object)new Date(Utils.toMillis(2010, 5, 13, 20, 15, 10))));
        Assert.assertThat((Object)entity.getMyEnum(), (Matcher)CoreMatchers.is((Object)MyEnum.BLUE));
        this.iswf.commitTran();
    }
}

