/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.scalar;

import java.util.List;
import org.apache.isis.applib.value.Date;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.scalars.ApplibValuedEntity;
import org.apache.isis.core.tck.dom.scalars.ApplibValuedEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persistAndUpdate_applibValuedEntity {
    private ApplibValuedEntityRepository repo = new ApplibValuedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("APPLIBVALUEDENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void persistTwo() throws Exception {
        this.iswf.beginTran();
        this.repo.newEntity().setStringProperty("1");
        this.repo.newEntity().setStringProperty("2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void persist_then_update() throws Exception {
        this.iswf.beginTran();
        ApplibValuedEntity entity = this.repo.newEntity();
        entity.setStringProperty("1");
        Date date = new Date();
        entity.setDateProperty(date);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (ApplibValuedEntity)this.repo.list().get(0);
        Assert.assertThat((Object)entity.getDateProperty().dateValue(), (Matcher)CoreMatchers.is((Object)date.dateValue()));
        date = date.add(-1, -1, -1);
        entity.setDateProperty(date);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        entity = (ApplibValuedEntity)this.repo.list().get(0);
        Assert.assertThat((Object)entity.getDateProperty().dateValue(), (Matcher)CoreMatchers.is((Object)date.dateValue()));
        this.iswf.commitTran();
    }
}

