/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.scalar;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntity;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_namedQuery_firstOnly {
    private PrimitiveValuedEntityRepository repo = new PrimitiveValuedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("PRIMITIVEVALUEDENTITY")).withServices(new Object[]{this.repo}).build();

    @Before
    public void setUp() throws Exception {
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = (PrimitiveValuedEntity)this.repo.newEntity();
        entity.setId(Integer.valueOf(1));
        entity.setIntProperty(111);
        entity = (PrimitiveValuedEntity)this.repo.newEntity();
        entity.setId(Integer.valueOf(2));
        entity.setIntProperty(222);
        entity = (PrimitiveValuedEntity)this.repo.newEntity();
        entity.setId(Integer.valueOf(3));
        entity.setIntProperty(333);
        entity = (PrimitiveValuedEntity)this.repo.newEntity();
        entity.setId(Integer.valueOf(4));
        entity.setIntProperty(111);
        this.iswf.commitTran();
    }

    @Test
    public void whenOne() throws Exception {
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = (PrimitiveValuedEntity)this.repo.findByNamedQueryFirstOnly("prmv_findByIntProperty", (Map)ImmutableMap.of((Object)"i", (Object)222));
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)entity.getId(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void whenTwo() throws Exception {
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = (PrimitiveValuedEntity)this.repo.findByNamedQueryFirstOnly("prmv_findByIntProperty", (Map)ImmutableMap.of((Object)"i", (Object)111));
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)entity.getId(), (Matcher)CoreMatchers.is((Object)1));
        this.iswf.commitTran();
    }

    @Test
    public void whenNone() throws Exception {
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = (PrimitiveValuedEntity)this.repo.findByNamedQueryFirstOnly("prmv_findByIntProperty", (Map)ImmutableMap.of((Object)"i", (Object)999));
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.iswf.commitTran();
    }
}

