/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.scalar;

import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntity;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_findInstance {
    private PrimitiveValuedEntityRepository repo = new PrimitiveValuedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("PRIMITIVEVALUEDENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void whenNoInstances() {
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = this.repo.findById(1);
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.iswf.commitTran();
    }

    @Test
    public void whenAnInstance() throws Exception {
        this.iswf.beginTran();
        ((PrimitiveValuedEntity)this.repo.newEntity()).setId(Integer.valueOf(1));
        this.iswf.commitTran();
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = this.repo.findById(1);
        Assert.assertThat((Object)entity, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)entity.getId(), (Matcher)CoreMatchers.is((Object)1));
        this.iswf.commitTran();
    }
}

