/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.scalar;

import java.util.List;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntity;
import org.apache.isis.core.tck.dom.scalars.PrimitiveValuedEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_allInstances {
    private PrimitiveValuedEntityRepository repo = new PrimitiveValuedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("PRIMITIVEVALUEDENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void whenNoInstances() {
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)0));
        this.iswf.commitTran();
    }

    @Test
    public void persist_dontBounce_listAll() throws Exception {
        this.iswf.beginTran();
        PrimitiveValuedEntity entity = (PrimitiveValuedEntity)this.repo.newEntity();
        entity.setId(Integer.valueOf(1));
        entity = (PrimitiveValuedEntity)this.repo.newEntity();
        entity.setId(Integer.valueOf(2));
        this.iswf.commitTran();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void persist_bounce_listAll() throws Exception {
        this.iswf.beginTran();
        ((PrimitiveValuedEntity)this.repo.newEntity()).setId(Integer.valueOf(1));
        ((PrimitiveValuedEntity)this.repo.newEntity()).setId(Integer.valueOf(2));
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }
}

