/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.refs;

import java.util.List;
import java.util.Set;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.refs.UnidirFkChildEntity;
import org.apache.isis.core.tck.dom.refs.UnidirFkParentEntity;
import org.apache.isis.core.tck.dom.refs.UnidirFkParentEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persist_unidir {
    private UnidirFkParentEntityRepository repo = new UnidirFkParentEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("UNIDIRFKCHILDENTITY")).with(Utils.listenerToDeleteFrom("UNIDIRFKPARENTENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void persistTwoParents() throws Exception {
        this.iswf.beginTran();
        ((UnidirFkParentEntity)this.repo.newEntity()).setName("Parent 1");
        ((UnidirFkParentEntity)this.repo.newEntity()).setName("Parent 2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void persistTwoChildrenOfParent() throws Exception {
        this.iswf.beginTran();
        ((UnidirFkParentEntity)this.repo.newEntity()).setName("Parent 1");
        ((UnidirFkParentEntity)this.repo.newEntity()).setName("Parent 2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        UnidirFkParentEntity retrievedEntity = (UnidirFkParentEntity)this.repo.list().get(0);
        retrievedEntity.newChild("Child 1 of Parent 1");
        retrievedEntity.newChild("Child 2 of Parent 1");
        retrievedEntity.newChild("Child 3 of Parent 1");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        retrievedEntity = (UnidirFkParentEntity)this.repo.list().get(0);
        Set children = retrievedEntity.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)3));
        this.iswf.commitTran();
    }

    @Ignore(value="Not currently working, is an update")
    @Test
    public void updateBidirectional() throws Exception {
        this.iswf.beginTran();
        UnidirFkParentEntity parent1 = (UnidirFkParentEntity)this.repo.newEntity();
        parent1.setName("Parent 1");
        UnidirFkParentEntity parent2 = (UnidirFkParentEntity)this.repo.newEntity();
        parent2.setName("Parent 2");
        parent1.newChild("Child 1 of Parent 1");
        parent1.newChild("Child 2 of Parent 1");
        parent1.newChild("Child 3 of Parent 1");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        parent1 = (UnidirFkParentEntity)this.repo.list().get(0);
        parent2 = (UnidirFkParentEntity)this.repo.list().get(0);
        Set children = parent1.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)3));
        UnidirFkChildEntity child1 = (UnidirFkChildEntity)parent1.getChildren().iterator().next();
        parent1.removeChild(child1);
        parent2.addChild(child1);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        parent1 = (UnidirFkParentEntity)this.repo.list().get(0);
        parent2 = (UnidirFkParentEntity)this.repo.list().get(0);
        children = parent1.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)2));
        children = parent2.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)1));
        this.iswf.commitTran();
    }
}

