/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.refs;

import java.util.List;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.refs.UnidirReferencedEntity;
import org.apache.isis.core.tck.dom.refs.UnidirReferencedEntityRepository;
import org.apache.isis.core.tck.dom.refs.UnidirReferencingEntity;
import org.apache.isis.core.tck.dom.refs.UnidirReferencingEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persist_referencing {
    private UnidirReferencingEntityRepository referencingRepo = new UnidirReferencingEntityRepository();
    private UnidirReferencedEntityRepository referencedRepo = new UnidirReferencedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("UNIDIRREFERENCINGENTITY")).with(Utils.listenerToDeleteFrom("UNIDIRREFERENCEDENTITY")).withServices(new Object[]{this.referencingRepo, this.referencedRepo}).build();

    @Test
    public void persist() throws Exception {
        this.iswf.beginTran();
        ((UnidirReferencedEntity)this.referencedRepo.newEntity()).setName("Referenced 1");
        ((UnidirReferencedEntity)this.referencedRepo.newEntity()).setName("Referenced 2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        UnidirReferencedEntity referencedEntity1 = (UnidirReferencedEntity)this.referencedRepo.list().get(0);
        UnidirReferencedEntity referencedEntity2 = (UnidirReferencedEntity)this.referencedRepo.list().get(1);
        UnidirReferencingEntity referencingEntity1 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity1.setName("Referencing 1");
        referencingEntity1.setReferenced(referencedEntity1);
        UnidirReferencingEntity referencingEntity2 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity2.setName("Referencing 2");
        referencingEntity2.setReferenced(referencedEntity1);
        UnidirReferencingEntity referencingEntity3 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity3.setName("Referencing 3");
        referencingEntity3.setReferenced(referencedEntity2);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.referencingRepo.list();
        referencingEntity1 = (UnidirReferencingEntity)list.get(0);
        referencingEntity2 = (UnidirReferencingEntity)list.get(1);
        referencingEntity3 = (UnidirReferencingEntity)list.get(2);
        Assert.assertThat((Object)referencingEntity1.getReferenced(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)referencingEntity2.getReferenced(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)referencingEntity3.getReferenced(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)referencingEntity1.getReferenced(), (Matcher)CoreMatchers.is((Object)referencingEntity1.getReferenced()));
        Assert.assertThat((Object)referencingEntity1.getReferenced(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)referencingEntity3.getReferenced())));
        this.iswf.commitTran();
    }

    @Test
    public void persistAGraphOfObjects() throws Exception {
        this.iswf.beginTran();
        UnidirReferencedEntity referencedEntity1 = (UnidirReferencedEntity)this.referencedRepo.newEntity();
        referencedEntity1.setName("Referenced 1");
        UnidirReferencedEntity referencedEntity2 = (UnidirReferencedEntity)this.referencedRepo.newEntity();
        referencedEntity2.setName("Referenced 2");
        UnidirReferencingEntity referencingEntity1 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity1.setName("Referencing 1");
        referencingEntity1.setReferenced(referencedEntity1);
        UnidirReferencingEntity referencingEntity2 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity2.setName("Referencing 2");
        referencingEntity2.setReferenced(referencedEntity1);
        UnidirReferencingEntity referencingEntity3 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity3.setName("Referencing 3");
        referencingEntity3.setReferenced(referencedEntity2);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.referencingRepo.list();
        referencingEntity1 = (UnidirReferencingEntity)list.get(0);
        referencingEntity2 = (UnidirReferencingEntity)list.get(1);
        referencingEntity3 = (UnidirReferencingEntity)list.get(2);
        Assert.assertThat((Object)referencingEntity1.getReferenced(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)referencingEntity2.getReferenced(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)referencingEntity3.getReferenced(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)referencingEntity1.getReferenced(), (Matcher)CoreMatchers.is((Object)referencingEntity1.getReferenced()));
        Assert.assertThat((Object)referencingEntity1.getReferenced(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)referencingEntity3.getReferenced())));
        this.iswf.commitTran();
    }
}

