/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.refs;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.refs.PolyInterfaceIdentityStrategyParentEntity;
import org.apache.isis.core.tck.dom.refs.PolyInterfaceIdentityStrategyParentEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persist_polyinterIdentityStrategy {
    private PolyInterfaceIdentityStrategyParentEntityRepository repo = new PolyInterfaceIdentityStrategyParentEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("POLYINTERFACEIDENTITYSTRATEGYPARENTENTITY_CHILDREN")).with(Utils.listenerToDeleteFrom("POLYINTERFACEIDENTITYSTRATEGYSUBTYPE1ENTITY")).with(Utils.listenerToDeleteFrom("POLYINTERFACEIDENTITYSTRATEGYSUBTYPE2ENTITY")).with(Utils.listenerToDeleteFrom("POLYINTERFACEIDENTITYSTRATEGYSUBTYPE3ENTITY")).with(Utils.listenerToDeleteFrom("POLYINTERFACEIDENTITYSTRATEGYPARENTENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void persistTwoParents() throws Exception {
        this.iswf.beginTran();
        ((PolyInterfaceIdentityStrategyParentEntity)this.repo.newEntity()).setName("Parent 1");
        ((PolyInterfaceIdentityStrategyParentEntity)this.repo.newEntity()).setName("Parent 2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void persistSixDifferentChildrenOfParent() throws Exception {
        this.iswf.beginTran();
        ((PolyInterfaceIdentityStrategyParentEntity)this.repo.newEntity()).setName("Parent 1");
        ((PolyInterfaceIdentityStrategyParentEntity)this.repo.newEntity()).setName("Parent 2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        PolyInterfaceIdentityStrategyParentEntity retrievedEntity = (PolyInterfaceIdentityStrategyParentEntity)this.repo.list().get(0);
        retrievedEntity.newSubtype1("Child 1 of Parent 1", 123);
        retrievedEntity.newSubtype1("Child 2 of Parent 1", 456);
        retrievedEntity.newSubtype2("Child 3 of Parent 1", "abc");
        retrievedEntity.newSubtype2("Child 4 of Parent 1", "def");
        retrievedEntity.newSubtype3("Child 5 of Parent 1", BigDecimal.ONE);
        retrievedEntity.newSubtype3("Child 6 of Parent 1", BigDecimal.TEN);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        retrievedEntity = (PolyInterfaceIdentityStrategyParentEntity)this.repo.list().get(0);
        Set children = retrievedEntity.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)6));
        this.iswf.commitTran();
    }
}

