/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.refs;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.refs.PolyInterfaceParentEntity;
import org.apache.isis.core.tck.dom.refs.PolyInterfaceParentEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persist_polyinter {
    private PolyInterfaceParentEntityRepository repo = new PolyInterfaceParentEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("POLYINTERFACEPARENTENTITY_CHILDREN")).with(Utils.listenerToDeleteFrom("POLYINTERFACESUBTYPE1ENTITY")).with(Utils.listenerToDeleteFrom("POLYINTERFACESUBTYPE2ENTITY")).with(Utils.listenerToDeleteFrom("POLYINTERFACESUBTYPE3ENTITY")).with(Utils.listenerToDeleteFrom("POLYINTERFACEPARENTENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void persistTwoParents() throws Exception {
        this.iswf.beginTran();
        ((PolyInterfaceParentEntity)this.repo.newEntity()).setName("Parent 1");
        ((PolyInterfaceParentEntity)this.repo.newEntity()).setName("Parent 2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void persistSixDifferentChildrenOfParent() throws Exception {
        this.iswf.beginTran();
        ((PolyInterfaceParentEntity)this.repo.newEntity()).setName("Parent 1");
        ((PolyInterfaceParentEntity)this.repo.newEntity()).setName("Parent 2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        PolyInterfaceParentEntity retrievedEntity = (PolyInterfaceParentEntity)this.repo.list().get(0);
        retrievedEntity.newSubtype1("Child 1 of Parent 1", 123);
        retrievedEntity.newSubtype1("Child 2 of Parent 1", 456);
        retrievedEntity.newSubtype2("Child 3 of Parent 1", "abc");
        retrievedEntity.newSubtype2("Child 4 of Parent 1", "def");
        retrievedEntity.newSubtype3("Child 5 of Parent 1", BigDecimal.ONE);
        retrievedEntity.newSubtype3("Child 6 of Parent 1", BigDecimal.TEN);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        retrievedEntity = (PolyInterfaceParentEntity)this.repo.list().get(0);
        Set children = retrievedEntity.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)6));
        this.iswf.commitTran();
    }
}

