/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.refs;

import java.util.List;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.tck.dom.refs.BidirWithListParentEntity;
import org.apache.isis.core.tck.dom.refs.BidirWithListParentEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persist_bidirWithListParent {
    private BidirWithListParentEntityRepository repo = new BidirWithListParentEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("BIDIRWITHLISTCHILDeNTITY")).with(Utils.listenerToDeleteFrom("BIDIRWITHLISTPARENTENTITY")).withServices(new Object[]{this.repo}).build();

    @Test
    public void persistTwoParents() throws Exception {
        this.iswf.beginTran();
        ((BidirWithListParentEntity)this.repo.newEntity()).setName("Parent 1");
        ((BidirWithListParentEntity)this.repo.newEntity()).setName("Parent 2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.repo.list();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        this.iswf.commitTran();
    }

    @Test
    public void persistTwoChildrenOfParent() throws Exception {
        this.iswf.beginTran();
        ((BidirWithListParentEntity)this.repo.newEntity()).setName("Parent 1");
        ((BidirWithListParentEntity)this.repo.newEntity()).setName("Parent 2");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        BidirWithListParentEntity retrievedEntity = (BidirWithListParentEntity)this.repo.list().get(0);
        retrievedEntity.newChild("Child 1 of Parent 1");
        retrievedEntity.newChild("Child 2 of Parent 1");
        retrievedEntity.newChild("Child 3 of Parent 1");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        retrievedEntity = (BidirWithListParentEntity)this.repo.list().get(0);
        List children = retrievedEntity.getChildren();
        Assert.assertThat((Object)children.size(), (Matcher)CoreMatchers.is((Object)3));
        this.iswf.commitTran();
    }
}

