/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.adaptermanager;

import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.tck.dom.refs.UnidirReferencedEntity;
import org.apache.isis.core.tck.dom.refs.UnidirReferencedEntityRepository;
import org.apache.isis.core.tck.dom.refs.UnidirReferencingEntity;
import org.apache.isis.core.tck.dom.refs.UnidirReferencingEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_persistentAdapterFor {
    private UnidirReferencingEntityRepository referencingRepo = new UnidirReferencingEntityRepository();
    private UnidirReferencedEntityRepository referencedRepo = new UnidirReferencedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("UNIDIRREFERENCINGENTITY")).with(Utils.listenerToDeleteFrom("UNIDIRREFERENCEDENTITY")).withServices(new Object[]{this.referencingRepo, this.referencedRepo}).build();

    @Test
    public void persist_then_update_using_persistentAdapterFor() throws Exception {
        this.iswf.beginTran();
        UnidirReferencedEntity referencedEntity1 = (UnidirReferencedEntity)this.referencedRepo.newEntity();
        referencedEntity1.setName("Referenced 1");
        UnidirReferencedEntity referencedEntity2 = (UnidirReferencedEntity)this.referencedRepo.newEntity();
        referencedEntity2.setName("Referenced 2");
        UnidirReferencingEntity referencingEntity1 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity1.setName("Referencing 1");
        referencingEntity1.setReferenced(referencedEntity1);
        UnidirReferencingEntity referencingEntity2 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity2.setName("Referencing 2");
        referencingEntity2.setReferenced(referencedEntity1);
        UnidirReferencingEntity referencingEntity3 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity3.setName("Referencing 3");
        referencingEntity3.setReferenced(referencedEntity2);
        this.iswf.commitTran();
        TypedOid referencingOid2 = (TypedOid)this.iswf.adapterFor((Object)referencingEntity2).getOid();
        TypedOid referencedOid1 = (TypedOid)this.iswf.adapterFor((Object)referencedEntity1).getOid();
        TypedOid referencedOid2 = (TypedOid)this.iswf.adapterFor((Object)referencedEntity2).getOid();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        ObjectAdapter referencingAdapter2 = this.iswf.getAdapterManager().adapterFor(referencingOid2);
        referencingEntity2 = (UnidirReferencingEntity)referencingAdapter2.getObject();
        UnidirReferencedEntity referenced = referencingEntity2.getReferenced();
        ObjectAdapter referencedAdapter1 = this.iswf.getAdapterManager().adapterFor(referencedOid1);
        Assert.assertThat((Object)referenced, (Matcher)CoreMatchers.is((Object)referencedAdapter1.getObject()));
        ObjectAdapter referencedAdapter2 = this.iswf.getAdapterManager().adapterFor(referencedOid2);
        referencedEntity2 = (UnidirReferencedEntity)referencedAdapter2.getObject();
        referencingEntity2.setReferenced(referencedEntity2);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        referencingAdapter2 = this.iswf.getAdapterManager().adapterFor(referencingOid2);
        referencingEntity2 = (UnidirReferencingEntity)referencingAdapter2.getObject();
        referenced = referencingEntity2.getReferenced();
        referencedAdapter2 = this.iswf.getAdapterManager().adapterFor(referencedOid2);
        Assert.assertThat((Object)referenced, (Matcher)CoreMatchers.is((Object)referencedAdapter2.getObject()));
        this.iswf.commitTran();
    }
}

