/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.scenarios.adaptermanager;

import java.util.List;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.tck.dom.refs.UnidirReferencedEntity;
import org.apache.isis.core.tck.dom.refs.UnidirReferencedEntityRepository;
import org.apache.isis.core.tck.dom.refs.UnidirReferencingEntity;
import org.apache.isis.core.tck.dom.refs.UnidirReferencingEntityRepository;
import org.apache.isis.objectstore.jdo.datanucleus.Utils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class Persistence_lazyLoading {
    private UnidirReferencingEntityRepository referencingRepo = new UnidirReferencingEntityRepository();
    private UnidirReferencedEntityRepository referencedRepo = new UnidirReferencedEntityRepository();
    @Rule
    public IsisSystemWithFixtures iswf = Utils.systemBuilder().with(Utils.listenerToDeleteFrom("UNIDIRREFERENCINGENTITY")).with(Utils.listenerToDeleteFrom("UNIDIRREFERENCEDENTITY")).withServices(new Object[]{this.referencingRepo, this.referencedRepo}).build();

    @Test
    public void lazyLoading_and_adapters() throws Exception {
        this.iswf.beginTran();
        ((UnidirReferencedEntity)this.referencedRepo.newEntity()).setName("Referenced 1");
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        UnidirReferencedEntity referencedEntity1 = (UnidirReferencedEntity)this.referencedRepo.list().get(0);
        UnidirReferencingEntity referencingEntity1 = (UnidirReferencingEntity)this.referencingRepo.newEntity();
        referencingEntity1.setName("Referencing 1");
        referencingEntity1.setReferenced(referencedEntity1);
        this.iswf.commitTran();
        this.iswf.bounceSystem();
        this.iswf.beginTran();
        List list = this.referencingRepo.list();
        referencingEntity1 = (UnidirReferencingEntity)list.get(0);
        Assert.assertThat((Object)referencingEntity1.referenced, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        UnidirReferencedEntity referenced = referencingEntity1.getReferenced();
        ObjectAdapter referencedAdapter = this.iswf.adapterFor((Object)referenced);
        Assert.assertThat((Object)referencedAdapter.getResolveState(), (Matcher)CoreMatchers.is((Object)ResolveState.RESOLVED));
        Assert.assertThat((Object)referenced, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.iswf.commitTran();
    }
}

