/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.spi;

import java.math.BigInteger;
import java.util.Date;
import javax.jdo.identity.IntIdentity;
import javax.jdo.identity.LongIdentity;
import javax.jdo.identity.StringIdentity;
import org.apache.isis.applib.annotation.ObjectType;
import org.apache.isis.core.commons.matchers.IsisMatchers;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOidDefault;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.spi.JdoObjectIdSerializer;
import org.datanucleus.identity.OIDImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class JdoObjectIdSerializerTest {
    @Rule
    public IsisSystemWithFixtures iswf = IsisSystemWithFixtures.builder().withServices(new Object[]{new CustomerRepository()}).build();

    @Test
    public void whenJavaxJdoIntIdentity() throws Exception {
        IntIdentity jdoObjectId = new IntIdentity(Customer.class, 123);
        String id = JdoObjectIdSerializer.toOidIdentifier((Object)jdoObjectId);
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.is((Object)"i_123"));
        RootOidDefault oid = RootOidDefault.create((ObjectSpecId)ObjectSpecId.of((String)"CUS"), (String)id);
        Object jdoObjectIdRecreated = JdoObjectIdSerializer.toJdoObjectId((RootOid)oid);
        Assert.assertThat((Object)jdoObjectIdRecreated, (Matcher)CoreMatchers.is((Object)jdoObjectId));
    }

    @Test
    public void whenJavaxJdoStringIdentity() throws Exception {
        StringIdentity jdoObjectId = new StringIdentity(Customer.class, "123");
        String id = JdoObjectIdSerializer.toOidIdentifier((Object)jdoObjectId);
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.is((Object)"s_123"));
        RootOidDefault oid = RootOidDefault.create((ObjectSpecId)ObjectSpecId.of((String)"CUS"), (String)id);
        Object jdoObjectIdRecreated = JdoObjectIdSerializer.toJdoObjectId((RootOid)oid);
        Assert.assertThat((Object)jdoObjectIdRecreated, (Matcher)CoreMatchers.is((Object)jdoObjectId));
    }

    @Test
    public void whenJavaxJdoLongIdentity() throws Exception {
        LongIdentity jdoObjectId = new LongIdentity(Customer.class, 123L);
        String id = JdoObjectIdSerializer.toOidIdentifier((Object)jdoObjectId);
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.is((Object)"l_123"));
        RootOidDefault oid = RootOidDefault.create((ObjectSpecId)ObjectSpecId.of((String)"CUS"), (String)id);
        Object jdoObjectIdRecreated = JdoObjectIdSerializer.toJdoObjectId((RootOid)oid);
        Assert.assertThat((Object)jdoObjectIdRecreated, (Matcher)CoreMatchers.is((Object)jdoObjectId));
    }

    @Test
    public void whenLong() throws Exception {
        OIDImpl jdoOid = new OIDImpl(Customer.class.getName(), (Object)123L);
        String id = JdoObjectIdSerializer.toOidIdentifier((Object)jdoOid);
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.is((Object)"L_123"));
        RootOidDefault oid = RootOidDefault.create((ObjectSpecId)ObjectSpecId.of((String)"CUS"), (String)id);
        Object jdoOidRecreated = JdoObjectIdSerializer.toJdoObjectId((RootOid)oid);
        Assert.assertThat((Object)jdoOidRecreated, (Matcher)CoreMatchers.is((Object)("123[OID]" + Customer.class.getName())));
    }

    @Test
    public void whenDataNucleusOidAndLong() throws Exception {
        OIDImpl jdoOid = new OIDImpl(Customer.class.getName(), (Object)123L);
        String id = JdoObjectIdSerializer.toOidIdentifier((Object)jdoOid);
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.is((Object)"L_123"));
        RootOidDefault oid = RootOidDefault.create((ObjectSpecId)ObjectSpecId.of((String)"CUS"), (String)id);
        Object jdoOidRecreated = JdoObjectIdSerializer.toJdoObjectId((RootOid)oid);
        Assert.assertThat((Object)jdoOidRecreated, (Matcher)CoreMatchers.is((Object)("123[OID]" + Customer.class.getName())));
    }

    @Test
    public void whenDataNucleusOidAndBigInteger() throws Exception {
        OIDImpl jdoOid = new OIDImpl(Customer.class.getName(), (Object)new BigInteger("123"));
        String id = JdoObjectIdSerializer.toOidIdentifier((Object)jdoOid);
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.is((Object)"B_123"));
        RootOidDefault oid = RootOidDefault.create((ObjectSpecId)ObjectSpecId.of((String)"CUS"), (String)id);
        Object jdoOidRecreated = JdoObjectIdSerializer.toJdoObjectId((RootOid)oid);
        Assert.assertThat((Object)jdoOidRecreated, (Matcher)CoreMatchers.is((Object)("123[OID]" + Customer.class.getName())));
    }

    @Test
    public void whenDataNucleusOidAndString() throws Exception {
        OIDImpl jdoOid = new OIDImpl(Customer.class.getName(), (Object)"456");
        String id = JdoObjectIdSerializer.toOidIdentifier((Object)jdoOid);
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.is((Object)"S_456"));
        RootOidDefault oid = RootOidDefault.create((ObjectSpecId)ObjectSpecId.of((String)"CUS"), (String)id);
        Object jdoOidRecreated = JdoObjectIdSerializer.toJdoObjectId((RootOid)oid);
        Assert.assertThat((Object)jdoOidRecreated, (Matcher)CoreMatchers.is((Object)("456[OID]" + Customer.class.getName())));
    }

    @Test
    public void whenDataNucleusOidAndOtherKeyValue() throws Exception {
        Date key = new Date();
        OIDImpl jdoOid = new OIDImpl(Customer.class.getName(), (Object)key);
        String id = JdoObjectIdSerializer.toOidIdentifier((Object)jdoOid);
        Assert.assertThat((Object)id, (Matcher)IsisMatchers.startsWith((String)(OIDImpl.class.getName() + "_" + key.toString())));
        RootOidDefault oid = RootOidDefault.create((ObjectSpecId)ObjectSpecId.of((String)"CUS"), (String)id);
        Object jdoOidRecreated = JdoObjectIdSerializer.toJdoObjectId((RootOid)oid);
        Assert.assertThat((Object)jdoOidRecreated, (Matcher)CoreMatchers.is((Object)(key.toString() + "[OID]" + Customer.class.getName())));
    }

    public static class CustomerRepository {
        public void foo(Customer x) {
        }
    }

    @ObjectType(value="CUS")
    public static class Customer {
    }
}

