/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.integtestsupport.IsisSystemWithFixtures;
import org.apache.isis.core.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusObjectStore;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusPersistenceMechanismInstaller;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class Utils {
    private Utils() {
    }

    public static IsisSystemWithFixtures.Builder systemBuilder() {
        return IsisSystemWithFixtures.builder().with(Utils.configurationForDataNucleusDb()).with((PersistenceMechanismInstaller)new DataNucleusPersistenceMechanismInstaller());
    }

    public static IsisSystemWithFixtures.Listener listenerToDeleteFrom(final String ... tables) {
        return new IsisSystemWithFixtures.ListenerAdapter(){

            public void postSetupSystem(boolean firstTime) throws Exception {
                Connection connection = this.getConnection();
                try {
                    Statement statement = connection.createStatement();
                    for (String table : tables) {
                        statement.executeUpdate("DELETE FROM " + table);
                    }
                }
                catch (Exception ex) {
                    connection.rollback();
                    throw ex;
                }
                finally {
                    connection.commit();
                }
            }

            private Connection getConnection() {
                DataNucleusObjectStore objectStore = (DataNucleusObjectStore)IsisContext.getPersistenceSession().getObjectStore();
                return objectStore.getJavaSqlConnection();
            }
        };
    }

    public static IsisConfiguration configurationForDataNucleusDb() {
        IsisConfigurationDefault configuration = new IsisConfigurationDefault();
        Properties props = new Properties();
        props.put("isis.persistor.datanucleus.impl.javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.api.jdo.JDOPersistenceManagerFactory");
        Utils.configureHsqlDbFileBased(props);
        Utils.configureForMsSqlServer(props);
        Utils.configureHsqlDbInMemory(props);
        props.put("isis.persistor.datanucleus.impl.datanucleus.autoCreateSchema", "true");
        props.put("isis.persistor.datanucleus.impl.datanucleus.validateTables", "true");
        props.put("isis.persistor.datanucleus.impl.datanucleus.validateConstraints", "true");
        props.put("isis.persistor.datanucleus.impl.datanucleus.cache.level2.type", "none");
        configuration.add(props);
        return configuration;
    }

    private static void configureHsqlDbInMemory(Properties props) {
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionDriverName", "org.hsqldb.jdbcDriver");
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionURL", "jdbc:hsqldb:mem:test");
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionUserName", "sa");
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionPassword", "");
    }

    private static void configureHsqlDbFileBased(Properties props) {
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionDriverName", "org.hsqldb.jdbcDriver");
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionURL", "jdbc:hsqldb:file:hsql-db/test;hsqldb.write_delay=false;shutdown=true");
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionUserName", "sa");
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionPassword", "");
    }

    private static void configureForMsSqlServer(Properties props) {
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionDriverName", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionURL", "jdbc:sqlserver://127.0.0.1:1433;instance=SQLEXPRESS;databaseName=jdo;");
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionUserName", "jdo");
        props.put("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionPassword", "jdopass");
    }

    public static long toMillis(int year, int monthOfYear, int dayOfMonth) {
        LocalDate d = new LocalDate(year, monthOfYear, dayOfMonth);
        return d.toDateMidnight().getMillis();
    }

    public static long toMillis(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute) {
        LocalDateTime d = new LocalDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute);
        return d.toDateTime().getMillis();
    }
}

