/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.jaxrsclient.impl.client;

import java.net.URI;
import java.util.HashMap;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.isis.extensions.jaxrsclient.applib.client.JaxRsClient;
import org.apache.isis.extensions.jaxrsclient.applib.client.JaxRsResponse;
import org.apache.isis.extensions.jaxrsclient.impl.client.JaxRsResponseDefault;

public class JaxRsClientDefault
implements JaxRsClient {
    protected final ClientBuilder clientBuilder = ClientBuilder.newBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxRsResponse get(URI uri, Class<?> dtoClass, JaxRsClient.ReprType reprType, String username, String password) {
        Client client = this.clientBuilder.build();
        try {
            WebTarget webTarget = client.target(uri);
            this.configureInvocationBuilder(webTarget);
            Invocation.Builder invocationBuilder = webTarget.request();
            invocationBuilder.accept(new MediaType[]{this.mediaTypeFor(dtoClass, reprType)});
            this.addBasicAuth(username, password, invocationBuilder);
            Invocation invocation = invocationBuilder.buildGet();
            Response response = invocation.invoke();
            JaxRsResponseDefault jaxRsResponseDefault = new JaxRsResponseDefault(response);
            return jaxRsResponseDefault;
        }
        finally {
            JaxRsClientDefault.closeQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxRsResponse post(URI uri, String bodyJson, String username, String password) {
        Client client = this.clientBuilder.build();
        try {
            WebTarget webTarget = client.target(uri);
            Invocation.Builder invocationBuilder = webTarget.request();
            this.configureInvocationBuilder(invocationBuilder);
            this.addBasicAuth(username, password, invocationBuilder);
            Entity entity = Entity.entity((Object)bodyJson, (MediaType)MediaType.APPLICATION_JSON_TYPE);
            Invocation invocation = invocationBuilder.buildPost(entity);
            Response response = invocation.invoke();
            JaxRsResponseDefault jaxRsResponseDefault = new JaxRsResponseDefault(response);
            return jaxRsResponseDefault;
        }
        finally {
            JaxRsClientDefault.closeQuietly(client);
        }
    }

    private Invocation.Builder addBasicAuth(String username, String password, Invocation.Builder invocationBuilder) {
        return invocationBuilder.header("Authorization", (Object)("Basic " + JaxRsClientDefault.encode(username, password)));
    }

    protected void configureInvocationBuilder(Object invocationBuilder) {
    }

    private MediaType mediaTypeFor(Class<?> dtoClass, JaxRsClient.ReprType reprType) {
        return this.mediaTypeFor(dtoClass, reprType.getSuffix());
    }

    private MediaType mediaTypeFor(Class<?> dtoClass, String reprType) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("profile", "urn:org.restfulobjects:repr-types/" + reprType);
        parameters.put("x-ro-domain-type", dtoClass.getName());
        return new MediaType("application", "xml", parameters);
    }

    private static String encode(String username, String password) {
        return Base64Utility.encode((byte[])JaxRsClientDefault.asBytes(username, password));
    }

    private static byte[] asBytes(String username, String password) {
        return String.format("%s:%s", username, password).getBytes();
    }

    private static void closeQuietly(Client client) {
        if (client == null) {
            return;
        }
        try {
            client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

