/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.userreg;

import java.util.Set;
import javax.inject.Inject;
import org.apache.isis.applib.services.userreg.UserDetails;
import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.applib.value.Password;
import org.apache.isis.core.commons.internal.base._Strings;
import org.apache.isis.extensions.secman.api.user.ApplicationUserStatus;
import org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole;
import org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRoleRepository;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUserRepository;

public abstract class SecurityModuleAppUserRegistrationServiceAbstract
implements UserRegistrationService {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;

    public boolean usernameExists(String username) {
        return this.applicationUserRepository.findByUsername(username).isPresent();
    }

    public void registerUser(UserDetails userDetails) {
        Set<ApplicationRole> additionalRoles;
        Password password = new Password(userDetails.getPassword());
        ApplicationRole initialRole = this.getInitialRole();
        String username = userDetails.getUsername();
        String emailAddress = userDetails.getEmailAddress();
        ApplicationUser applicationUser = (ApplicationUser)this.applicationUserRepository.newLocalUser(username, password, ApplicationUserStatus.ENABLED);
        if (_Strings.isNotEmpty((CharSequence)emailAddress)) {
            applicationUser.setEmailAddress(emailAddress);
        }
        if (initialRole != null) {
            this.applicationRoleRepository.addRoleToUser(initialRole, applicationUser);
        }
        if ((additionalRoles = this.getAdditionalInitialRoles()) != null) {
            for (ApplicationRole additionalRole : additionalRoles) {
                this.applicationRoleRepository.addRoleToUser(additionalRole, applicationUser);
            }
        }
    }

    public boolean emailExists(String emailAddress) {
        return this.applicationUserRepository.findByEmailAddress(emailAddress).isPresent();
    }

    public boolean updatePasswordByEmail(String emailAddress, String password) {
        boolean passwordUpdated = false;
        ApplicationUser user = this.applicationUserRepository.findByEmailAddress(emailAddress).orElse(null);
        if (user != null) {
            passwordUpdated = this.applicationUserRepository.updatePassword(user, password);
        }
        return passwordUpdated;
    }

    protected abstract ApplicationRole getInitialRole();

    protected abstract Set<ApplicationRole> getAdditionalInitialRoles();
}

