/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.seed.scripts;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.value.Password;
import org.apache.isis.core.commons.internal.collections._Lists;
import org.apache.isis.core.commons.internal.exceptions._Exceptions;
import org.apache.isis.extensions.secman.api.user.AccountType;
import org.apache.isis.extensions.secman.api.user.ApplicationUserStatus;
import org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole;
import org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRoleRepository;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUserRepository;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScript;

public class AbstractUserAndRolesFixtureScript
extends FixtureScript {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;
    private final String username;
    private final String password;
    private final String emailAddress;
    private final String tenancyPath;
    private final AccountType accountType;
    private final List<String> roleNames;
    private ApplicationUser applicationUser;

    public AbstractUserAndRolesFixtureScript(String username, String password, AccountType accountType, List<String> roleNames) {
        this(username, password, null, null, accountType, roleNames);
    }

    public AbstractUserAndRolesFixtureScript(String username, String password, String emailAddress, String tenancyPath, AccountType accountType, List<String> roleNames) {
        this.username = username;
        this.password = password;
        this.emailAddress = emailAddress;
        this.tenancyPath = tenancyPath;
        this.accountType = accountType;
        this.roleNames = Collections.unmodifiableList(_Lists.newArrayList(roleNames));
    }

    protected void execute(FixtureScript.ExecutionContext executionContext) {
        this.applicationUser = this.applicationUserRepository.findByUsername(this.username).orElse(null);
        if (this.applicationUser == null) {
            switch (this.accountType) {
                case DELEGATED: {
                    this.applicationUser = (ApplicationUser)this.applicationUserRepository.newDelegateUser(this.username, ApplicationUserStatus.ENABLED);
                    break;
                }
                case LOCAL: {
                    Password pwd = new Password(this.password);
                    this.applicationUser = (ApplicationUser)this.applicationUserRepository.newLocalUser(this.username, pwd, ApplicationUserStatus.ENABLED);
                    this.applicationUser.setEmailAddress(this.emailAddress);
                }
            }
            if (this.applicationUser == null) {
                throw _Exceptions.unrecoverableFormatted((String)"failed to create user '%s'", (Object[])new Object[]{this.username});
            }
            this.applicationUser.setAtPath(this.tenancyPath);
            for (String roleName : this.roleNames) {
                ApplicationRole securityRole = this.applicationRoleRepository.findByName(roleName).orElse(null);
                if (securityRole != null) {
                    this.applicationRoleRepository.addRoleToUser(securityRole, this.applicationUser);
                    continue;
                }
                throw _Exceptions.unrecoverable((String)("role not found by name: " + roleName));
            }
        }
    }

    public ApplicationUser getApplicationUser() {
        return this.applicationUser;
    }
}

