/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.seed.scripts;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.isis.core.commons.internal.base._NullSafe;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionMode;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionRule;
import org.apache.isis.extensions.secman.api.role.ApplicationRole;
import org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermissionRepository;
import org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRoleRepository;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScript;

public abstract class AbstractRoleAndPermissionsFixtureScript
extends FixtureScript {
    @Inject
    private ApplicationRoleRepository applicationRoleRepository;
    @Inject
    private ApplicationPermissionRepository applicationPermissionRepository;
    private final String roleName;
    private final String roleDescription;

    protected AbstractRoleAndPermissionsFixtureScript(String roleName, String roleDescriptionIfAny) {
        this.roleName = roleName;
        this.roleDescription = roleDescriptionIfAny;
    }

    protected abstract void execute(FixtureScript.ExecutionContext var1);

    protected void newPackagePermissions(ApplicationPermissionRule rule, ApplicationPermissionMode mode, String ... featureFqns) {
        this.newPermissions(rule, mode, ApplicationFeatureType.PACKAGE, Arrays.asList(featureFqns));
    }

    protected void newClassPermissions(ApplicationPermissionRule rule, ApplicationPermissionMode mode, Class<?> ... classes) {
        this.newPermissions(rule, mode, ApplicationFeatureType.CLASS, AbstractRoleAndPermissionsFixtureScript.asFeatureFqns(classes));
    }

    protected void newMemberPermissions(ApplicationPermissionRule rule, ApplicationPermissionMode mode, Class<?> cls, String ... members) {
        this.newPermissions(rule, mode, ApplicationFeatureType.MEMBER, AbstractRoleAndPermissionsFixtureScript.asFeatureFqns(cls, members));
    }

    private void newPermissions(ApplicationPermissionRule rule, ApplicationPermissionMode mode, ApplicationFeatureType featureType, Iterable<String> featureFqns) {
        if (featureFqns == null) {
            return;
        }
        ApplicationRole securityRole = this.applicationRoleRepository.findByName(this.roleName).orElse(null);
        if (securityRole == null) {
            securityRole = this.applicationRoleRepository.newRole(this.roleName, this.roleDescription);
        }
        for (String featureFqn : featureFqns) {
            this.applicationPermissionRepository.newPermissionNoCheck((org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole)securityRole, rule, mode, featureType, featureFqn);
        }
    }

    private static List<String> asFeatureFqns(Class<?>[] classes) {
        return _NullSafe.stream((Object[])classes).map(Class::getName).collect(Collectors.toList());
    }

    private static Iterable<String> asFeatureFqns(Class<?> cls, String[] members) {
        return _NullSafe.stream((Object[])members).map(memberName -> {
            StringBuilder buf = new StringBuilder(cls.getName());
            if (!memberName.startsWith("#")) {
                buf.append("#");
            }
            buf.append((String)memberName);
            return buf.toString();
        }).collect(Collectors.toList());
    }
}

