/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.seed;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.core.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.runtime.context.session.AppLifecycleEvent;
import org.apache.isis.extensions.secman.jdo.seed.SeedUsersAndRolesFixtureScript;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScript;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScripts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isisExtSecman.SeedSecurityModuleService")
@Order(value=0)
@Qualifier(value="Default")
public class SeedSecurityModuleService {
    private static final Logger log = LogManager.getLogger(SeedSecurityModuleService.class);
    private final FixtureScripts fixtureScripts;

    @Inject
    public SeedSecurityModuleService(FixtureScripts fixtureScripts) {
        this.fixtureScripts = fixtureScripts;
    }

    @EventListener(value={AppLifecycleEvent.class})
    public void onAppLifecycleEvent(AppLifecycleEvent event) {
        AppLifecycleEvent.EventType eventType = event.getEventType();
        log.debug("received app lifecycle event {}", (Object)eventType);
        switch (eventType) {
            case appPreMetamodel: {
                break;
            }
            case appPostMetamodel: {
                log.info("SEED");
                this.fixtureScripts.run(new FixtureScript[]{new SeedUsersAndRolesFixtureScript()});
                break;
            }
            default: {
                throw _Exceptions.unmatchedCase((Object)eventType);
            }
        }
    }
}

