/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.dom.user;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import lombok.NonNull;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.queryresultscache.QueryResultsCache;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.core.commons.internal.base._Casts;
import org.apache.isis.core.commons.internal.collections._Sets;
import org.apache.isis.core.commons.internal.exceptions._Exceptions;
import org.apache.isis.extensions.secman.api.SecurityModuleConfig;
import org.apache.isis.extensions.secman.api.encryption.PasswordEncryptionService;
import org.apache.isis.extensions.secman.api.role.ApplicationRole;
import org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy;
import org.apache.isis.extensions.secman.api.user.AccountType;
import org.apache.isis.extensions.secman.api.user.ApplicationUserStatus;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser;
import org.apache.isis.extensions.secman.model.dom.user.ApplicationUser_lock;
import org.apache.isis.extensions.secman.model.dom.user.ApplicationUser_unlock;
import org.springframework.stereotype.Repository;

@Repository
@Named(value="isisExtSecman.applicationUserRepository")
public class ApplicationUserRepository
implements org.apache.isis.extensions.secman.api.user.ApplicationUserRepository<ApplicationUser> {
    @Inject
    private FactoryService factoryService;
    @Inject
    private RepositoryService repository;
    @Inject
    private SecurityModuleConfig configBean;
    @Inject
    private Optional<PasswordEncryptionService> passwordEncryptionService;
    @Inject
    private Provider<QueryResultsCache> queryResultsCacheProvider;

    public ApplicationUser newApplicationUser() {
        return (ApplicationUser)this.factoryService.detachedEntity(ApplicationUser.class);
    }

    public ApplicationUser findOrCreateUserByUsername(String username) {
        return (ApplicationUser)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.findByUsername(username).orElseGet(() -> (ApplicationUser)this.newDelegateUser(username, null)), ApplicationUserRepository.class, "findOrCreateUserByUsername", new Object[]{username});
    }

    public Optional<ApplicationUser> findByUsernameCached(String username) {
        return (Optional)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByUsername, ApplicationUserRepository.class, "findByUsernameCached", (Object)username);
    }

    public Optional<ApplicationUser> findByUsername(String username) {
        return this.repository.uniqueMatch((Query)new QueryDefault(ApplicationUser.class, "findByUsername", new Object[]{"username", username}));
    }

    public Optional<ApplicationUser> findByEmailAddressCached(String emailAddress) {
        return (Optional)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByEmailAddress, ApplicationUserRepository.class, "findByEmailAddressCached", (Object)emailAddress);
    }

    public Optional<ApplicationUser> findByEmailAddress(String emailAddress) {
        return this.repository.uniqueMatch((Query)new QueryDefault(ApplicationUser.class, "findByEmailAddress", new Object[]{"emailAddress", emailAddress}));
    }

    public Collection<ApplicationUser> find(String search) {
        String regex = String.format("(?i).*%s.*", search.replace("*", ".*").replace("?", "."));
        return (Collection)this.repository.allMatches((Query)new QueryDefault(ApplicationUser.class, "find", new Object[]{"regex", regex})).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public Collection<ApplicationUser> findByAtPath(String atPath) {
        return (Collection)this.repository.allMatches((Query)new QueryDefault(ApplicationUser.class, "findByAtPath", new Object[]{"atPath", atPath})).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public Collection<ApplicationUser> findByRole(ApplicationRole genericRole) {
        org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole role = (org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole)_Casts.uncheckedCast((Object)genericRole);
        return (Collection)role.getUsers().stream().collect(_Sets.toUnmodifiableSorted());
    }

    public Collection<ApplicationUser> findByTenancy(@NonNull ApplicationTenancy genericTenancy) {
        if (genericTenancy == null) {
            throw new NullPointerException("genericTenancy is marked non-null but is null");
        }
        return (Collection)this.findByAtPath(genericTenancy.getPath()).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public Collection<ApplicationUser> allUsers() {
        return (Collection)this.repository.allInstances(ApplicationUser.class).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public Collection<ApplicationUser> findMatching(String search) {
        if (search != null && search.length() > 0) {
            return this.find(search);
        }
        return Collections.emptySortedSet();
    }

    public void enable(org.apache.isis.extensions.secman.api.user.ApplicationUser user) {
        if (user.getStatus() != ApplicationUserStatus.ENABLED) {
            ((ApplicationUser_unlock)this.factoryService.mixin(ApplicationUser_unlock.class, (Object)user)).act();
        }
    }

    public void disable(org.apache.isis.extensions.secman.api.user.ApplicationUser user) {
        if (user.getStatus() != ApplicationUserStatus.DISABLED) {
            ((ApplicationUser_lock)this.factoryService.mixin(ApplicationUser_lock.class, (Object)user)).act();
        }
    }

    public boolean isAdminUser(org.apache.isis.extensions.secman.api.user.ApplicationUser user) {
        return this.configBean.getAdminUserName().equals(user.getName());
    }

    public ApplicationUser newUser(String username, AccountType accountType, Consumer<ApplicationUser> beforePersist) {
        ApplicationUser user = this.newApplicationUser();
        user.setUsername(username);
        user.setAccountType(accountType);
        user.setStatus(ApplicationUserStatus.DISABLED);
        beforePersist.accept(user);
        this.repository.persistAndFlush((Object)user);
        return user;
    }

    public boolean updatePassword(org.apache.isis.extensions.secman.api.user.ApplicationUser user, String password) {
        if (!this.isPasswordFeatureEnabled(user)) {
            return false;
        }
        PasswordEncryptionService encrypter = this.passwordEncryptionService.orElseThrow(_Exceptions::unexpectedCodeReach);
        user.setEncryptedPassword(encrypter.encrypt(password));
        this.repository.persistAndFlush((Object)user);
        return true;
    }

    public boolean isPasswordFeatureEnabled(org.apache.isis.extensions.secman.api.user.ApplicationUser user) {
        return user.isLocalAccount() && this.passwordEncryptionService != null && this.passwordEncryptionService.isPresent();
    }
}

