/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.dom.user;

import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.DatastoreIdentity;
import javax.jdo.annotations.Element;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import javax.jdo.annotations.Version;
import javax.jdo.annotations.VersionStrategy;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.annotation.CollectionLayout;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.user.RoleMemento;
import org.apache.isis.applib.services.user.UserMemento;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.core.commons.internal.base._Strings;
import org.apache.isis.core.commons.internal.collections._Lists;
import org.apache.isis.extensions.secman.api.SecurityModuleConfig;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionValueSet;
import org.apache.isis.extensions.secman.api.permission.PermissionsEvaluationService;
import org.apache.isis.extensions.secman.api.user.AccountType;
import org.apache.isis.extensions.secman.api.user.ApplicationUser;
import org.apache.isis.extensions.secman.api.user.ApplicationUserStatus;
import org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission;
import org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermissionRepository;
import org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUserRepository;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;

@PersistenceCapable(identityType=IdentityType.DATASTORE, schema="isissecurity", table="ApplicationUser")
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@DatastoreIdentity(strategy=IdGeneratorStrategy.NATIVE, column="id")
@Version(strategy=VersionStrategy.VERSION_NUMBER, column="version")
@Uniques(value={@Unique(name="ApplicationUser_username_UNQ", members={"username"})})
@Queries(value={@Query(name="findByUsername", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser WHERE username == :username"), @Query(name="findByEmailAddress", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser WHERE emailAddress == :emailAddress"), @Query(name="findByAtPath", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser WHERE atPath == :atPath"), @Query(name="findByName", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser WHERE username.matches(:nameRegex)   || familyName.matches(:nameRegex)   || givenName.matches(:nameRegex)   || knownAs.matches(:nameRegex)"), @Query(name="find", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser WHERE username.matches(:regex) || familyName.matches(:regex) || givenName.matches(:regex) || knownAs.matches(:regex) || emailAddress.matches(:regex)")})
@DomainObject(objectType="isissecurity.ApplicationUser", autoCompleteRepository=ApplicationUserRepository.class, autoCompleteAction="findMatching")
@DomainObjectLayout(bookmarking=BookmarkPolicy.AS_ROOT)
public class ApplicationUser
implements Comparable<ApplicationUser>,
org.apache.isis.extensions.secman.api.user.ApplicationUser {
    @Inject
    private ApplicationUserRepository applicationUserRepository;
    @Inject
    private ApplicationPermissionRepository applicationPermissionRepository;
    @Inject
    private UserService userService;
    @Inject
    private PermissionsEvaluationService permissionsEvaluationService;
    @Inject
    private SecurityModuleConfig configBean;
    @Column(allowsNull="false", length=30)
    @Property(domainEvent=UsernameDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.PARENTED_TABLES)
    @MemberOrder(name="Id", sequence="1")
    private String username;
    @Column(allowsNull="true", length=50)
    @Property(domainEvent=FamilyNameDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.ALL_TABLES)
    @MemberOrder(name="Name", sequence="2.1")
    private String familyName;
    @Column(allowsNull="true", length=50)
    @Property(domainEvent=GivenNameDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.ALL_TABLES)
    @MemberOrder(name="Name", sequence="2.2")
    private String givenName;
    @Column(allowsNull="true", length=20)
    @Property(domainEvent=KnownAsDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.ALL_TABLES)
    @MemberOrder(name="Name", sequence="2.3")
    private String knownAs;
    @Column(allowsNull="true", length=50)
    @Property(domainEvent=EmailAddressDomainEvent.class, editing=Editing.DISABLED)
    @MemberOrder(name="Contact Details", sequence="3.1")
    private String emailAddress;
    @Column(allowsNull="true", length=25)
    @Property(domainEvent=PhoneNumberDomainEvent.class, editing=Editing.DISABLED)
    @MemberOrder(name="Contact Details", sequence="3.2")
    private String phoneNumber;
    @Column(allowsNull="true", length=25)
    @Property(domainEvent=FaxNumberDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.PARENTED_TABLES)
    @MemberOrder(name="Contact Details", sequence="3.3")
    private String faxNumber;
    @Column(name="atPath", allowsNull="true")
    @Property(domainEvent=AtPathDomainEvent.class, editing=Editing.DISABLED)
    @MemberOrder(name="atPath", sequence="3.4")
    private String atPath;
    @Column(allowsNull="false")
    @Property(domainEvent=AccountTypeDomainEvent.class, editing=Editing.DISABLED)
    @MemberOrder(name="Status", sequence="3")
    private AccountType accountType;
    @Column(allowsNull="false")
    @Property(domainEvent=StatusDomainEvent.class, editing=Editing.DISABLED)
    @MemberOrder(name="Status", sequence="4")
    private ApplicationUserStatus status;
    @Column(allowsNull="true")
    @PropertyLayout(hidden=Where.EVERYWHERE)
    private String encryptedPassword;
    @Persistent(table="ApplicationUserRoles")
    @Join(column="userId")
    @Element(column="roleId")
    @Collection(domainEvent=RolesDomainEvent.class, editing=Editing.DISABLED)
    @CollectionLayout(defaultView="table")
    @MemberOrder(sequence="20")
    private SortedSet<ApplicationRole> roles = new TreeSet<ApplicationRole>();
    private transient ApplicationPermissionValueSet cachedPermissionSet;
    private static final String propertyNames = "username";
    private static final ObjectContracts.ObjectContract<ApplicationUser> contract = ObjectContracts.parse(ApplicationUser.class, (String)"username");
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = ApplicationUser.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = ApplicationUser.__dnGetInheritedFieldCount();

    public String title() {
        return this.getName();
    }

    public String iconName() {
        return this.getStatus().isEnabled() ? "enabled" : "disabled";
    }

    @NotPersistent
    @Property(domainEvent=NameDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.OBJECT_FORMS)
    @MemberOrder(name="Id", sequence="1")
    public String getName() {
        StringBuilder buf = new StringBuilder();
        if (this.getFamilyName() != null) {
            if (this.getKnownAs() != null) {
                buf.append(this.getKnownAs());
            } else {
                buf.append(this.getGivenName());
            }
            buf.append(' ').append(this.getFamilyName()).append(" (").append(this.getUsername()).append(')');
        } else {
            buf.append(this.getUsername());
        }
        return buf.toString();
    }

    public boolean hideEncryptedPassword() {
        return !this.applicationUserRepository.isPasswordFeatureEnabled(this);
    }

    @Property(domainEvent=HasPasswordDomainEvent.class, editing=Editing.DISABLED)
    @MemberOrder(name="Status", sequence="4")
    public boolean isHasPassword() {
        return _Strings.isNotEmpty((CharSequence)this.getEncryptedPassword());
    }

    public boolean hideHasPassword() {
        return !this.applicationUserRepository.isPasswordFeatureEnabled(this);
    }

    @Programmatic
    public ApplicationPermissionValueSet getPermissionSet() {
        if (this.cachedPermissionSet != null) {
            return this.cachedPermissionSet;
        }
        List<ApplicationPermission> permissions = this.applicationPermissionRepository.findByUser(this);
        this.cachedPermissionSet = new ApplicationPermissionValueSet(_Lists.map(permissions, ApplicationPermission.Functions.AS_VALUE), this.permissionsEvaluationService);
        return this.cachedPermissionSet;
    }

    public boolean isForSelfOrRunAsAdministrator() {
        return this.isForSelf() || this.isRunAsAdministrator();
    }

    boolean isForSelf() {
        String currentUserName = this.userService.getUser().getName();
        return Objects.equals(this.getUsername(), currentUserName);
    }

    boolean isRunAsAdministrator() {
        UserMemento currentUser = this.userService.getUser();
        List roles = currentUser.getRoles();
        String adminRoleSuffix = ":" + this.configBean.getAdminRoleName();
        for (RoleMemento role : roles) {
            String roleName = role.getName();
            if (!roleName.endsWith(adminRoleSuffix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(ApplicationUser o) {
        return contract.compare((Object)this, (Object)o);
    }

    public boolean equals(Object obj) {
        return contract.equals((Object)this, obj);
    }

    public int hashCode() {
        return contract.hashCode((Object)this);
    }

    public String toString() {
        return contract.toString((Object)this);
    }

    public String getUsername() {
        return ApplicationUser.dnGetusername(this);
    }

    public void setUsername(String username) {
        ApplicationUser.dnSetusername(this, username);
    }

    public String getFamilyName() {
        return ApplicationUser.dnGetfamilyName(this);
    }

    public void setFamilyName(String familyName) {
        ApplicationUser.dnSetfamilyName(this, familyName);
    }

    public String getGivenName() {
        return ApplicationUser.dnGetgivenName(this);
    }

    public void setGivenName(String givenName) {
        ApplicationUser.dnSetgivenName(this, givenName);
    }

    public String getKnownAs() {
        return ApplicationUser.dnGetknownAs(this);
    }

    public void setKnownAs(String knownAs) {
        ApplicationUser.dnSetknownAs(this, knownAs);
    }

    public String getEmailAddress() {
        return ApplicationUser.dnGetemailAddress(this);
    }

    public void setEmailAddress(String emailAddress) {
        ApplicationUser.dnSetemailAddress(this, emailAddress);
    }

    public String getPhoneNumber() {
        return ApplicationUser.dnGetphoneNumber(this);
    }

    public void setPhoneNumber(String phoneNumber) {
        ApplicationUser.dnSetphoneNumber(this, phoneNumber);
    }

    public String getFaxNumber() {
        return ApplicationUser.dnGetfaxNumber(this);
    }

    public void setFaxNumber(String faxNumber) {
        ApplicationUser.dnSetfaxNumber(this, faxNumber);
    }

    public String getAtPath() {
        return ApplicationUser.dnGetatPath(this);
    }

    public void setAtPath(String atPath) {
        ApplicationUser.dnSetatPath(this, atPath);
    }

    public AccountType getAccountType() {
        return ApplicationUser.dnGetaccountType(this);
    }

    public void setAccountType(AccountType accountType) {
        ApplicationUser.dnSetaccountType(this, accountType);
    }

    public ApplicationUserStatus getStatus() {
        return ApplicationUser.dnGetstatus(this);
    }

    public void setStatus(ApplicationUserStatus status) {
        ApplicationUser.dnSetstatus(this, status);
    }

    public String getEncryptedPassword() {
        return ApplicationUser.dnGetencryptedPassword(this);
    }

    public void setEncryptedPassword(String encryptedPassword) {
        ApplicationUser.dnSetencryptedPassword(this, encryptedPassword);
    }

    public SortedSet<ApplicationRole> getRoles() {
        return ApplicationUser.dnGetroles(this);
    }

    public void setRoles(SortedSet<ApplicationRole> roles) {
        ApplicationUser.dnSetroles(this, roles);
    }

    static {
        EnhancementHelper.registerClass((Class)ApplicationUser.___dn$loadClass("org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser"), (Persistable)new ApplicationUser());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return null;
    }

    public Object dnNewObjectIdInstance(Object key) {
        return null;
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        ApplicationUser result = new ApplicationUser();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        ApplicationUser result = new ApplicationUser();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.accountType = (AccountType)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.atPath = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.emailAddress = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.encryptedPassword = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 4: {
                this.familyName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.faxNumber = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 6: {
                this.givenName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.knownAs = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 8: {
                this.phoneNumber = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 9: {
                this.roles = (SortedSet)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 10: {
                this.status = (ApplicationUserStatus)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 11: {
                this.username = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.accountType);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.atPath);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.emailAddress);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.encryptedPassword);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.familyName);
                break;
            }
            case 5: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.faxNumber);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.givenName);
                break;
            }
            case 7: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.knownAs);
                break;
            }
            case 8: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.phoneNumber);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.roles);
                break;
            }
            case 10: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.status);
                break;
            }
            case 11: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.username);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(ApplicationUser obj, int index) {
        switch (index) {
            case 0: {
                this.accountType = obj.accountType;
                break;
            }
            case 1: {
                this.atPath = obj.atPath;
                break;
            }
            case 2: {
                this.emailAddress = obj.emailAddress;
                break;
            }
            case 3: {
                this.encryptedPassword = obj.encryptedPassword;
                break;
            }
            case 4: {
                this.familyName = obj.familyName;
                break;
            }
            case 5: {
                this.faxNumber = obj.faxNumber;
                break;
            }
            case 6: {
                this.givenName = obj.givenName;
                break;
            }
            case 7: {
                this.knownAs = obj.knownAs;
                break;
            }
            case 8: {
                this.phoneNumber = obj.phoneNumber;
                break;
            }
            case 9: {
                this.roles = obj.roles;
                break;
            }
            case 10: {
                this.status = obj.status;
                break;
            }
            case 11: {
                this.username = obj.username;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof ApplicationUser)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser");
        }
        ApplicationUser other = (ApplicationUser)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"accountType", "atPath", "emailAddress", "encryptedPassword", "familyName", "faxNumber", "givenName", "knownAs", "phoneNumber", "roles", "status", propertyNames};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 12;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static AccountType dnGetaccountType(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (AccountType)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, (Object)objPC.accountType);
        }
        return objPC.accountType;
    }

    private static void dnSetaccountType(ApplicationUser objPC, AccountType val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, (Object)objPC.accountType, (Object)val);
        } else {
            objPC.accountType = val;
        }
    }

    private static String dnGetatPath(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.atPath);
        }
        return objPC.atPath;
    }

    private static void dnSetatPath(ApplicationUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.atPath, val);
        } else {
            objPC.atPath = val;
        }
    }

    private static String dnGetemailAddress(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2, objPC.emailAddress);
        }
        return objPC.emailAddress;
    }

    private static void dnSetemailAddress(ApplicationUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2, objPC.emailAddress, val);
        } else {
            objPC.emailAddress = val;
        }
    }

    private static String dnGetencryptedPassword(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3, objPC.encryptedPassword);
        }
        return objPC.encryptedPassword;
    }

    private static void dnSetencryptedPassword(ApplicationUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3, objPC.encryptedPassword, val);
        } else {
            objPC.encryptedPassword = val;
        }
    }

    private static String dnGetfamilyName(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.familyName);
        }
        return objPC.familyName;
    }

    private static void dnSetfamilyName(ApplicationUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.familyName, val);
        } else {
            objPC.familyName = val;
        }
    }

    private static String dnGetfaxNumber(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 5, objPC.faxNumber);
        }
        return objPC.faxNumber;
    }

    private static void dnSetfaxNumber(ApplicationUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 5, objPC.faxNumber, val);
        } else {
            objPC.faxNumber = val;
        }
    }

    private static String dnGetgivenName(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6, objPC.givenName);
        }
        return objPC.givenName;
    }

    private static void dnSetgivenName(ApplicationUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6, objPC.givenName, val);
        } else {
            objPC.givenName = val;
        }
    }

    private static String dnGetknownAs(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 7, objPC.knownAs);
        }
        return objPC.knownAs;
    }

    private static void dnSetknownAs(ApplicationUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 7, objPC.knownAs, val);
        } else {
            objPC.knownAs = val;
        }
    }

    private static String dnGetphoneNumber(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 8, objPC.phoneNumber);
        }
        return objPC.phoneNumber;
    }

    private static void dnSetphoneNumber(ApplicationUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 8, objPC.phoneNumber, val);
        } else {
            objPC.phoneNumber = val;
        }
    }

    private static SortedSet dnGetroles(ApplicationUser objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9)) {
            return (SortedSet)objPC.dnStateManager.getObjectField((Persistable)objPC, 9, objPC.roles);
        }
        return objPC.roles;
    }

    private static void dnSetroles(ApplicationUser objPC, SortedSet val) {
        if (objPC.dnStateManager == null) {
            objPC.roles = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9, objPC.roles, (Object)val);
        }
    }

    private static ApplicationUserStatus dnGetstatus(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 10)) {
            return (ApplicationUserStatus)objPC.dnStateManager.getObjectField((Persistable)objPC, 10, (Object)objPC.status);
        }
        return objPC.status;
    }

    private static void dnSetstatus(ApplicationUser objPC, ApplicationUserStatus val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 10, (Object)objPC.status, (Object)val);
        } else {
            objPC.status = val;
        }
    }

    private static String dnGetusername(ApplicationUser objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 11)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 11, objPC.username);
        }
        return objPC.username;
    }

    private static void dnSetusername(ApplicationUser objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 11, objPC.username, val);
        } else {
            objPC.username = val;
        }
    }

    public static class RolesDomainEvent
    extends ApplicationUser.CollectionDomainEvent<ApplicationRole> {
    }

    public static class HasPasswordDomainEvent
    extends ApplicationUser.PropertyDomainEvent<Boolean> {
    }

    public static class StatusDomainEvent
    extends ApplicationUser.PropertyDomainEvent<ApplicationUserStatus> {
    }

    public static class AccountTypeDomainEvent
    extends ApplicationUser.PropertyDomainEvent<AccountType> {
    }

    public static class AtPathDomainEvent
    extends ApplicationUser.PropertyDomainEvent<String> {
    }

    public static class FaxNumberDomainEvent
    extends ApplicationUser.PropertyDomainEvent<String> {
    }

    public static class PhoneNumberDomainEvent
    extends ApplicationUser.PropertyDomainEvent<String> {
    }

    public static class EmailAddressDomainEvent
    extends ApplicationUser.PropertyDomainEvent<String> {
    }

    public static class KnownAsDomainEvent
    extends ApplicationUser.PropertyDomainEvent<String> {
    }

    public static class GivenNameDomainEvent
    extends ApplicationUser.PropertyDomainEvent<String> {
    }

    public static class FamilyNameDomainEvent
    extends ApplicationUser.PropertyDomainEvent<String> {
    }

    public static class UsernameDomainEvent
    extends ApplicationUser.PropertyDomainEvent<String> {
    }

    public static class NameDomainEvent
    extends ApplicationUser.PropertyDomainEvent<String> {
    }
}

