/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.dom.tenancy;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import lombok.NonNull;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.queryresultscache.QueryResultsCache;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.core.commons.internal.base._Casts;
import org.apache.isis.core.commons.internal.collections._Sets;
import org.apache.isis.extensions.secman.jdo.dom.tenancy.ApplicationTenancy;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser;
import org.springframework.stereotype.Repository;

@Repository
@Named(value="isisExtSecman.applicationTenancyRepository")
public class ApplicationTenancyRepository
implements org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancyRepository<ApplicationTenancy> {
    @Inject
    private FactoryService factory;
    @Inject
    private RepositoryService repository;
    @Inject
    private Provider<QueryResultsCache> queryResultsCacheProvider;

    public ApplicationTenancy newApplicationTenancy() {
        return (ApplicationTenancy)this.factory.detachedEntity(ApplicationTenancy.class);
    }

    public Collection<ApplicationTenancy> findByNameOrPathMatchingCached(final String search) {
        return (Collection)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute((Callable)new Callable<Collection<ApplicationTenancy>>(){

            @Override
            public Collection<ApplicationTenancy> call() throws Exception {
                return ApplicationTenancyRepository.this.findByNameOrPathMatching(search);
            }
        }, ApplicationTenancyRepository.class, "findByNameOrPathMatchingCached", new Object[]{search});
    }

    public Collection<ApplicationTenancy> findByNameOrPathMatching(String search) {
        if (search == null) {
            return Collections.emptySortedSet();
        }
        return (Collection)this.repository.allMatches((Query)new QueryDefault(ApplicationTenancy.class, "findByNameOrPathMatching", new Object[]{"regex", String.format("(?i).*%s.*", search.replace("*", ".*").replace("?", "."))})).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public ApplicationTenancy findByNameCached(final String name) {
        return (ApplicationTenancy)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute((Callable)new Callable<ApplicationTenancy>(){

            @Override
            public ApplicationTenancy call() throws Exception {
                return ApplicationTenancyRepository.this.findByName(name);
            }
        }, ApplicationTenancyRepository.class, "findByNameCached", new Object[]{name});
    }

    public ApplicationTenancy findByName(String name) {
        return this.repository.uniqueMatch((Query)new QueryDefault(ApplicationTenancy.class, "findByName", new Object[]{"name", name})).orElse(null);
    }

    public ApplicationTenancy findByPathCached(final String path) {
        return (ApplicationTenancy)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute((Callable)new Callable<ApplicationTenancy>(){

            @Override
            public ApplicationTenancy call() throws Exception {
                return ApplicationTenancyRepository.this.findByPath(path);
            }
        }, ApplicationTenancyRepository.class, "findByPathCached", new Object[]{path});
    }

    public ApplicationTenancy findByPath(String path) {
        if (path == null) {
            return null;
        }
        return this.repository.uniqueMatch((Query)new QueryDefault(ApplicationTenancy.class, "findByPath", new Object[]{"path", path})).orElse(null);
    }

    public Collection<ApplicationTenancy> findMatching(String search) {
        if (search != null && search.length() > 0) {
            return this.findByNameOrPathMatching(search);
        }
        return Collections.emptySortedSet();
    }

    public ApplicationTenancy newTenancy(String name, String path, org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy parent) {
        ApplicationTenancy tenancy = this.findByPath(path);
        if (tenancy == null) {
            tenancy = this.newApplicationTenancy();
            tenancy.setName(name);
            tenancy.setPath(path);
            tenancy.setParent((ApplicationTenancy)parent);
            this.repository.persist((Object)tenancy);
        }
        return tenancy;
    }

    public Collection<ApplicationTenancy> allTenancies() {
        return (Collection)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute((Callable)new Callable<Collection<ApplicationTenancy>>(){

            @Override
            public Collection<ApplicationTenancy> call() throws Exception {
                return ApplicationTenancyRepository.this.allTenanciesNoCache();
            }
        }, ApplicationTenancyRepository.class, "allTenancies", new Object[0]);
    }

    public Collection<ApplicationTenancy> allTenanciesNoCache() {
        return (Collection)this.repository.allInstances(ApplicationTenancy.class).stream().map(ApplicationTenancy.class::cast).collect(_Sets.toUnmodifiableSorted());
    }

    public void setTenancyOnUser(@NonNull org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy genericTenancy, @NonNull org.apache.isis.extensions.secman.api.user.ApplicationUser genericUser) {
        if (genericTenancy == null) {
            throw new NullPointerException("genericTenancy is marked non-null but is null");
        }
        if (genericUser == null) {
            throw new NullPointerException("genericUser is marked non-null but is null");
        }
        ApplicationTenancy tenancy = (ApplicationTenancy)_Casts.uncheckedCast((Object)genericTenancy);
        ApplicationUser user = (ApplicationUser)_Casts.uncheckedCast((Object)genericUser);
        user.setAtPath(tenancy.getPath());
    }

    public void clearTenancyOnUser(@NonNull org.apache.isis.extensions.secman.api.user.ApplicationUser genericUser) {
        if (genericUser == null) {
            throw new NullPointerException("genericUser is marked non-null but is null");
        }
        ApplicationUser user = (ApplicationUser)_Casts.uncheckedCast((Object)genericUser);
        user.setAtPath(null);
    }

    public void setParentOnTenancy(@NonNull org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy genericTenancy, @NonNull org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy genericParent) {
        if (genericTenancy == null) {
            throw new NullPointerException("genericTenancy is marked non-null but is null");
        }
        if (genericParent == null) {
            throw new NullPointerException("genericParent is marked non-null but is null");
        }
        ApplicationTenancy tenancy = (ApplicationTenancy)_Casts.uncheckedCast((Object)genericTenancy);
        ApplicationTenancy parent = (ApplicationTenancy)_Casts.uncheckedCast((Object)genericParent);
        tenancy.setParent(parent);
    }

    public void clearParentOnTenancy(@NonNull org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy genericTenancy) {
        if (genericTenancy == null) {
            throw new NullPointerException("genericTenancy is marked non-null but is null");
        }
        ApplicationTenancy tenancy = (ApplicationTenancy)_Casts.uncheckedCast((Object)genericTenancy);
        tenancy.setParent(null);
    }

    public Collection<ApplicationTenancy> getChildren(@NonNull org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy genericTenancy) {
        if (genericTenancy == null) {
            throw new NullPointerException("genericTenancy is marked non-null but is null");
        }
        ApplicationTenancy tenancy = (ApplicationTenancy)_Casts.uncheckedCast((Object)genericTenancy);
        return (Collection)tenancy.getChildren().stream().collect(_Sets.toUnmodifiableSorted());
    }
}

