/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.dom.tenancy;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.DatastoreIdentity;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import javax.jdo.annotations.Version;
import javax.jdo.annotations.VersionStrategy;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.annotation.CollectionLayout;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.util.Equality;
import org.apache.isis.applib.util.Hashing;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy;
import org.apache.isis.extensions.secman.jdo.dom.tenancy.ApplicationTenancyRepository;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.StringId;

@PersistenceCapable(identityType=IdentityType.APPLICATION, schema="isissecurity", table="ApplicationTenancy")
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@DatastoreIdentity(strategy=IdGeneratorStrategy.NATIVE, column="id")
@Version(strategy=VersionStrategy.VERSION_NUMBER, column="version")
@Uniques(value={@Unique(name="ApplicationTenancy_name_UNQ", members={"name"})})
@Queries(value={@Query(name="findByPath", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.tenancy.ApplicationTenancy WHERE path == :path"), @Query(name="findByName", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.tenancy.ApplicationTenancy WHERE name == :name"), @Query(name="findByNameOrPathMatching", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.tenancy.ApplicationTenancy WHERE name.matches(:regex) || path.matches(:regex) ")})
@DomainObject(objectType="isissecurity.ApplicationTenancy", autoCompleteRepository=ApplicationTenancyRepository.class, autoCompleteAction="findMatching")
@DomainObjectLayout(bookmarking=BookmarkPolicy.AS_ROOT)
public class ApplicationTenancy
implements Comparable<ApplicationTenancy>,
org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy {
    @Column(allowsNull="false", length=40)
    @Title
    @Property(domainEvent=NameDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(typicalLength=20)
    @MemberOrder(sequence="1")
    private String name;
    @PrimaryKey
    @Column(length=255, allowsNull="false")
    @Property(domainEvent=PathDomainEvent.class, editing=Editing.DISABLED)
    private String path;
    @Column(name="parentPath", allowsNull="true")
    @Property(domainEvent=ParentDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.PARENTED_TABLES)
    private ApplicationTenancy parent;
    @Persistent(mappedBy="parent")
    @Collection(domainEvent=ChildrenDomainEvent.class, editing=Editing.DISABLED)
    @CollectionLayout(defaultView="table")
    private SortedSet<ApplicationTenancy> children = new TreeSet<ApplicationTenancy>();
    private static final Equality<ApplicationTenancy> equality = ObjectContracts.checkEquals(ApplicationTenancy::getPath);
    private static final Hashing<ApplicationTenancy> hashing = ObjectContracts.hashing(ApplicationTenancy::getPath);
    private static final ToString<ApplicationTenancy> toString = ObjectContracts.toString((String)"path", ApplicationTenancy::getPath).thenToString("name", ApplicationTenancy::getName);
    private static final Comparator<ApplicationTenancy> comparator = Comparator.comparing(ApplicationTenancy::getPath);
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = ApplicationTenancy.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = ApplicationTenancy.__dnGetInheritedFieldCount();

    public void addToChildren(ApplicationTenancy applicationTenancy) {
        this.getChildren().add(applicationTenancy);
    }

    public void removeFromChildren(ApplicationTenancy applicationTenancy) {
        this.getChildren().remove(applicationTenancy);
    }

    public boolean equals(Object other) {
        return equality.equals((Object)this, other);
    }

    public int hashCode() {
        return hashing.hashCode((Object)this);
    }

    public String toString() {
        return toString.toString((Object)this);
    }

    @Override
    public int compareTo(ApplicationTenancy o) {
        return comparator.compare(this, o);
    }

    public String getName() {
        return ApplicationTenancy.dnGetname(this);
    }

    public void setName(String name) {
        ApplicationTenancy.dnSetname(this, name);
    }

    public String getPath() {
        return ApplicationTenancy.dnGetpath(this);
    }

    public void setPath(String path) {
        ApplicationTenancy.dnSetpath(this, path);
    }

    public ApplicationTenancy getParent() {
        return ApplicationTenancy.dnGetparent(this);
    }

    public void setParent(ApplicationTenancy parent) {
        ApplicationTenancy.dnSetparent(this, parent);
    }

    public SortedSet<ApplicationTenancy> getChildren() {
        return ApplicationTenancy.dnGetchildren(this);
    }

    public void setChildren(SortedSet<ApplicationTenancy> children) {
        ApplicationTenancy.dnSetchildren(this, children);
    }

    static {
        EnhancementHelper.registerClass((Class)ApplicationTenancy.___dn$loadClass("org.apache.isis.extensions.secman.jdo.dom.tenancy.ApplicationTenancy"), (Persistable)new ApplicationTenancy());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.StringId");
        }
        StringId o = (StringId)oid;
        fc.storeStringField(3, o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.StringId or null");
        }
        StringId o = (StringId)oid;
        this.path = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new StringId(this.getClass(), this.path);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringId(this.getClass(), (String)key);
        }
        return new StringId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        ApplicationTenancy result = new ApplicationTenancy();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        ApplicationTenancy result = new ApplicationTenancy();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.children = (SortedSet)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.name = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.parent = (ApplicationTenancy)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.path = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.children);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.name);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.parent);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.path);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(ApplicationTenancy obj, int index) {
        switch (index) {
            case 0: {
                this.children = obj.children;
                break;
            }
            case 1: {
                this.name = obj.name;
                break;
            }
            case 2: {
                this.parent = obj.parent;
                break;
            }
            case 3: {
                this.path = obj.path;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof ApplicationTenancy)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.isis.extensions.secman.jdo.dom.tenancy.ApplicationTenancy");
        }
        ApplicationTenancy other = (ApplicationTenancy)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"children", "name", "parent", "path"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 4;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static SortedSet dnGetchildren(ApplicationTenancy objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (SortedSet)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, objPC.children);
        }
        return objPC.children;
    }

    private static void dnSetchildren(ApplicationTenancy objPC, SortedSet val) {
        if (objPC.dnStateManager == null) {
            objPC.children = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, objPC.children, (Object)val);
        }
    }

    private static String dnGetname(ApplicationTenancy objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.name);
        }
        return objPC.name;
    }

    private static void dnSetname(ApplicationTenancy objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.name, val);
        } else {
            objPC.name = val;
        }
    }

    private static ApplicationTenancy dnGetparent(ApplicationTenancy objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (ApplicationTenancy)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, (Object)objPC.parent);
        }
        return objPC.parent;
    }

    private static void dnSetparent(ApplicationTenancy objPC, ApplicationTenancy val) {
        if (objPC.dnStateManager == null) {
            objPC.parent = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, (Object)objPC.parent, (Object)val);
        }
    }

    private static String dnGetpath(ApplicationTenancy objPC) {
        return objPC.path;
    }

    private static void dnSetpath(ApplicationTenancy objPC, String val) {
        if (objPC.dnStateManager == null) {
            objPC.path = val;
        } else {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3, objPC.path, val);
        }
    }

    public static class ChildrenDomainEvent
    extends ApplicationTenancy.CollectionDomainEvent<ApplicationTenancy> {
    }

    public static class ParentDomainEvent
    extends ApplicationTenancy.PropertyDomainEvent<ApplicationTenancy> {
    }

    public static class PathDomainEvent
    extends ApplicationTenancy.PropertyDomainEvent<String> {
    }

    public static class NameDomainEvent
    extends ApplicationTenancy.PropertyDomainEvent<String> {
    }
}

