/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.dom.role;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.queryresultscache.QueryResultsCache;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.core.commons.internal.base._Casts;
import org.apache.isis.core.commons.internal.collections._Sets;
import org.apache.isis.extensions.secman.api.SecurityModuleConfig;
import org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission;
import org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser;
import org.apache.isis.extensions.secman.model.dom.permission.ApplicationPermission_delete;
import org.springframework.stereotype.Repository;

@Repository
@Named(value="isisExtSecman.applicationRoleRepository")
public class ApplicationRoleRepository
implements org.apache.isis.extensions.secman.api.role.ApplicationRoleRepository<ApplicationRole> {
    @Inject
    private FactoryService factoryService;
    @Inject
    private RepositoryService repository;
    @Inject
    private SecurityModuleConfig configBean;
    @Inject
    private Provider<QueryResultsCache> queryResultsCacheProvider;

    public ApplicationRole newApplicationRole() {
        return (ApplicationRole)this.factoryService.detachedEntity(ApplicationRole.class);
    }

    public Optional<ApplicationRole> findByNameCached(String name) {
        return (Optional)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(() -> this.findByName(name), ApplicationRoleRepository.class, "findByNameCached", new Object[]{name});
    }

    public Optional<ApplicationRole> findByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return this.repository.uniqueMatch((Query)new QueryDefault(ApplicationRole.class, "findByName", new Object[]{"name", name}));
    }

    public Collection<ApplicationRole> findNameContaining(String search) {
        if (search != null && search.length() > 0) {
            String nameRegex = String.format("(?i).*%s.*", search.replace("*", ".*").replace("?", "."));
            return (Collection)this.repository.allMatches((Query)new QueryDefault(ApplicationRole.class, "findByNameContaining", new Object[]{"nameRegex", nameRegex})).stream().collect(_Sets.toUnmodifiableSorted());
        }
        return Collections.emptySortedSet();
    }

    public ApplicationRole newRole(String name, String description) {
        ApplicationRole role = this.findByName(name).orElse(null);
        if (role == null) {
            role = this.newApplicationRole();
            role.setName(name);
            role.setDescription(description);
            this.repository.persist((Object)role);
        }
        return role;
    }

    public Collection<ApplicationRole> allRoles() {
        return (Collection)this.repository.allInstances(ApplicationRole.class).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public Collection<ApplicationRole> findMatching(String search) {
        if (search != null && search.length() > 0) {
            return this.findNameContaining(search);
        }
        return Collections.emptySortedSet();
    }

    public void addRoleToUser(org.apache.isis.extensions.secman.api.role.ApplicationRole genericRole, org.apache.isis.extensions.secman.api.user.ApplicationUser genericUser) {
        ApplicationRole role = (ApplicationRole)_Casts.uncheckedCast((Object)genericRole);
        ApplicationUser user = (ApplicationUser)_Casts.uncheckedCast((Object)genericUser);
        user.getRoles().add(role);
    }

    public void removeRoleFromUser(org.apache.isis.extensions.secman.api.role.ApplicationRole genericRole, org.apache.isis.extensions.secman.api.user.ApplicationUser genericUser) {
        ApplicationRole role = (ApplicationRole)_Casts.uncheckedCast((Object)genericRole);
        ApplicationUser user = (ApplicationUser)_Casts.uncheckedCast((Object)genericUser);
        user.getRoles().remove(role);
    }

    public boolean isAdminRole(org.apache.isis.extensions.secman.api.role.ApplicationRole genericRole) {
        ApplicationRole adminRole = this.findByNameCached(this.configBean.getAdminRoleName()).orElse(null);
        return Objects.equals(adminRole, genericRole);
    }

    public void deleteRole(org.apache.isis.extensions.secman.api.role.ApplicationRole genericRole) {
        ApplicationRole role = (ApplicationRole)_Casts.uncheckedCast((Object)genericRole);
        role.getUsers().clear();
        List<ApplicationPermission> permissions = role.getPermissions();
        for (ApplicationPermission permission : permissions) {
            ApplicationPermission_delete deleteMixin = (ApplicationPermission_delete)this.factoryService.mixin(ApplicationPermission_delete.class, (Object)permission);
            deleteMixin.act();
        }
        this.repository.removeAndFlush((Object)role);
    }

    public Collection<ApplicationRole> getRoles(org.apache.isis.extensions.secman.api.user.ApplicationUser genericUser) {
        ApplicationUser user = (ApplicationUser)_Casts.uncheckedCast((Object)genericUser);
        return user.getRoles();
    }
}

