/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.dom.role;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.DatastoreIdentity;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.Bounding;
import org.apache.isis.applib.annotation.CollectionLayout;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.services.appfeat.ApplicationFeatureRepository;
import org.apache.isis.applib.util.Equality;
import org.apache.isis.applib.util.Hashing;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.applib.util.ToString;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionMode;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionRule;
import org.apache.isis.extensions.secman.api.role.ApplicationRole;
import org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission;
import org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermissionRepository;
import org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRoleRepository;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;

@PersistenceCapable(identityType=IdentityType.DATASTORE, schema="isissecurity", table="ApplicationRole")
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@DatastoreIdentity(strategy=IdGeneratorStrategy.NATIVE, column="id")
@Uniques(value={@Unique(name="ApplicationRole_name_UNQ", members={"name"})})
@Queries(value={@Query(name="findByName", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole WHERE name == :name"), @Query(name="findByNameContaining", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole WHERE name.matches(:nameRegex) ")})
@DomainObject(bounding=Bounding.BOUNDED, objectType="isissecurity.ApplicationRole", autoCompleteRepository=ApplicationRoleRepository.class, autoCompleteAction="findMatching")
@DomainObjectLayout(bookmarking=BookmarkPolicy.AS_ROOT)
public class ApplicationRole
implements org.apache.isis.extensions.secman.api.role.ApplicationRole,
Comparable<ApplicationRole> {
    @Inject
    private ApplicationFeatureRepository applicationFeatureRepository;
    @Inject
    private ApplicationPermissionRepository applicationPermissionRepository;
    @Column(allowsNull="false", length=50)
    @Property(domainEvent=NameDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(typicalLength=30)
    @MemberOrder(sequence="1")
    private String name;
    @Column(allowsNull="true", length=254)
    @Property(domainEvent=DescriptionDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(typicalLength=50)
    @MemberOrder(sequence="2")
    private String description;
    @Persistent(mappedBy="roles")
    @org.apache.isis.applib.annotation.Collection(domainEvent=UsersDomainEvent.class, editing=Editing.DISABLED)
    @CollectionLayout(defaultView="table")
    @MemberOrder(sequence="20")
    private SortedSet<ApplicationUser> users = new TreeSet<ApplicationUser>();
    private static final Comparator<ApplicationRole> comparator = Comparator.comparing(ApplicationRole::getName);
    private static final Equality<ApplicationRole> equality = ObjectContracts.checkEquals(ApplicationRole::getName);
    private static final Hashing<ApplicationRole> hashing = ObjectContracts.hashing(ApplicationRole::getName);
    private static final ToString<ApplicationRole> toString = ObjectContracts.toString((String)"name", ApplicationRole::getName);
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = ApplicationRole.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = ApplicationRole.__dnGetInheritedFieldCount();

    public String title() {
        return this.getName();
    }

    @org.apache.isis.applib.annotation.Collection(domainEvent=PermissionsCollectionDomainEvent.class)
    @CollectionLayout(defaultView="table", sortedBy=ApplicationPermission.DefaultComparator.class)
    @MemberOrder(sequence="10")
    public List<ApplicationPermission> getPermissions() {
        return this.applicationPermissionRepository.findByRole(this);
    }

    public Collection<String> choices2AddClass() {
        return this.applicationFeatureRepository.packageNamesContainingClasses(null);
    }

    public Collection<String> choices3AddClass(ApplicationPermissionRule rule, ApplicationPermissionMode mode, String packageFqn) {
        return this.applicationFeatureRepository.classNamesContainedIn(packageFqn, null);
    }

    public void addToUsers(ApplicationUser applicationUser) {
        this.getUsers().add(applicationUser);
    }

    public void removeFromUsers(ApplicationUser applicationUser) {
        this.getUsers().remove(applicationUser);
    }

    @Override
    public int compareTo(ApplicationRole o) {
        return comparator.compare(this, o);
    }

    public boolean equals(Object obj) {
        return equality.equals((Object)this, obj);
    }

    public int hashCode() {
        return hashing.hashCode((Object)this);
    }

    public String toString() {
        return toString.toString((Object)this);
    }

    public String getName() {
        return ApplicationRole.dnGetname(this);
    }

    public void setName(String name) {
        ApplicationRole.dnSetname(this, name);
    }

    public String getDescription() {
        return ApplicationRole.dnGetdescription(this);
    }

    public void setDescription(String description) {
        ApplicationRole.dnSetdescription(this, description);
    }

    public SortedSet<ApplicationUser> getUsers() {
        return ApplicationRole.dnGetusers(this);
    }

    public void setUsers(SortedSet<ApplicationUser> users) {
        ApplicationRole.dnSetusers(this, users);
    }

    static {
        EnhancementHelper.registerClass((Class)ApplicationRole.___dn$loadClass("org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole"), (Persistable)new ApplicationRole());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return null;
    }

    public Object dnNewObjectIdInstance(Object key) {
        return null;
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        ApplicationRole result = new ApplicationRole();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        ApplicationRole result = new ApplicationRole();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.description = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.name = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.users = (SortedSet)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.description);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.name);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.users);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(ApplicationRole obj, int index) {
        switch (index) {
            case 0: {
                this.description = obj.description;
                break;
            }
            case 1: {
                this.name = obj.name;
                break;
            }
            case 2: {
                this.users = obj.users;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof ApplicationRole)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole");
        }
        ApplicationRole other = (ApplicationRole)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"description", "name", "users"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 3;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static String dnGetdescription(ApplicationRole objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.description);
        }
        return objPC.description;
    }

    private static void dnSetdescription(ApplicationRole objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.description, val);
        } else {
            objPC.description = val;
        }
    }

    private static String dnGetname(ApplicationRole objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.name);
        }
        return objPC.name;
    }

    private static void dnSetname(ApplicationRole objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.name, val);
        } else {
            objPC.name = val;
        }
    }

    private static SortedSet dnGetusers(ApplicationRole objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (SortedSet)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, objPC.users);
        }
        return objPC.users;
    }

    private static void dnSetusers(ApplicationRole objPC, SortedSet val) {
        if (objPC.dnStateManager == null) {
            objPC.users = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, objPC.users, (Object)val);
        }
    }

    public static class UsersDomainEvent
    extends ApplicationRole.CollectionDomainEvent<ApplicationUser> {
    }

    public static class PermissionsCollectionDomainEvent
    extends ApplicationRole.CollectionDomainEvent<ApplicationPermission> {
    }

    public static class DescriptionDomainEvent
    extends ApplicationRole.PropertyDomainEvent<String> {
    }

    public static class NameDomainEvent
    extends ApplicationRole.PropertyDomainEvent<String> {
    }
}

