/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.dom.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import lombok.NonNull;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;
import org.apache.isis.applib.services.appfeat.ApplicationMemberType;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.services.queryresultscache.QueryResultsCache;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.core.commons.internal.base._Casts;
import org.apache.isis.core.commons.internal.base._NullSafe;
import org.apache.isis.core.commons.internal.base._Strings;
import org.apache.isis.core.commons.internal.collections._Lists;
import org.apache.isis.core.commons.internal.collections._Multimaps;
import org.apache.isis.core.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeature;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureId;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureRepositoryDefault;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionMode;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionRule;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionValue;
import org.apache.isis.extensions.secman.api.role.ApplicationRole;
import org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission;
import org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser;
import org.springframework.stereotype.Repository;

@Repository
@Named(value="isisExtSecman.applicationPermissionRepository")
public class ApplicationPermissionRepository
implements org.apache.isis.extensions.secman.api.permission.ApplicationPermissionRepository<ApplicationPermission> {
    @Inject
    private RepositoryService repository;
    @Inject
    private ApplicationFeatureRepositoryDefault applicationFeatureRepository;
    @Inject
    private FactoryService factory;
    @Inject
    private MessageService messages;
    @Inject
    private Provider<QueryResultsCache> queryResultsCacheProvider;

    public ApplicationPermission newApplicationPermission() {
        return (ApplicationPermission)this.factory.detachedEntity(ApplicationPermission.class);
    }

    public List<ApplicationPermission> findByRoleCached(@NonNull org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        return (List)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByRole, ApplicationPermissionRepository.class, "findByRoleCached", (Object)role);
    }

    public List<ApplicationPermission> findByRole(@NonNull org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        return this.repository.allMatches((Query)new QueryDefault(ApplicationPermission.class, "findByRole", new Object[]{"role", role}));
    }

    public List<ApplicationPermission> findByUserCached(@NonNull ApplicationUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return (List)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByUser, ApplicationPermissionRepository.class, "findByUserCached", (Object)user);
    }

    public List<ApplicationPermission> findByUser(@NonNull ApplicationUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.findByUser(user.getUsername());
    }

    private List<ApplicationPermission> findByUser(String username) {
        return this.repository.allMatches((Query)new QueryDefault(ApplicationPermission.class, "findByUser", new Object[]{"username", username}));
    }

    public Optional<ApplicationPermission> findByUserAndPermissionValue(String username, ApplicationPermissionValue permissionValue) {
        _Multimaps.ListMultimap permissions = (_Multimaps.ListMultimap)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::permissionsByPermissionValue, ApplicationPermissionRepository.class, "findByUserAndPermissionValue", (Object)username);
        List applicationPermissions = (List)permissions.get((Object)permissionValue);
        return applicationPermissions != null && !applicationPermissions.isEmpty() ? Optional.of(applicationPermissions.get(0)) : Optional.empty();
    }

    private _Multimaps.ListMultimap<ApplicationPermissionValue, ApplicationPermission> permissionsByPermissionValue(String username) {
        _Multimaps.ListMultimap permissionsByPermissionValue = _Multimaps.newListMultimap();
        List<ApplicationPermission> permissions = this.findByUser(username);
        _NullSafe.stream(permissions).forEach(permission -> {
            ApplicationPermissionValue newPermissionValue = ApplicationPermission.Functions.AS_VALUE.apply((ApplicationPermission)permission);
            permissionsByPermissionValue.putElement((Object)newPermissionValue, permission);
        });
        return permissionsByPermissionValue;
    }

    public Collection<ApplicationPermission> findByRoleAndRuleAndFeatureTypeCached(ApplicationRole role, ApplicationPermissionRule rule, ApplicationFeatureType type) {
        return (Collection)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByRoleAndRuleAndFeatureType, ApplicationPermissionRepository.class, "findByRoleAndRuleAndFeatureTypeCached", (Object)role, (Object)rule, (Object)type);
    }

    public Collection<ApplicationPermission> findByRoleAndRuleAndFeatureType(ApplicationRole role, ApplicationPermissionRule rule, ApplicationFeatureType type) {
        return (Collection)this.repository.allMatches((Query)new QueryDefault(ApplicationPermission.class, "findByRoleAndRuleAndFeatureType", new Object[]{"role", role, "rule", rule, "featureType", type})).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public Optional<ApplicationPermission> findByRoleAndRuleAndFeatureCached(ApplicationRole role, ApplicationPermissionRule rule, ApplicationFeatureType type, String featureFqn) {
        return (Optional)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByRoleAndRuleAndFeature, ApplicationPermissionRepository.class, "findByRoleAndRuleAndFeatureCached", (Object)role, (Object)rule, (Object)type, (Object)featureFqn);
    }

    public Optional<ApplicationPermission> findByRoleAndRuleAndFeature(ApplicationRole role, ApplicationPermissionRule rule, ApplicationFeatureType type, String featureFqn) {
        return this.repository.uniqueMatch((Query)new QueryDefault(ApplicationPermission.class, "findByRoleAndRuleAndFeature", new Object[]{"role", role, "rule", rule, "featureType", type, "featureFqn", featureFqn}));
    }

    public Collection<ApplicationPermission> findByFeatureCached(ApplicationFeatureId featureId) {
        return (Collection)((QueryResultsCache)this.queryResultsCacheProvider.get()).execute(this::findByFeature, ApplicationPermissionRepository.class, "findByFeatureCached", (Object)featureId);
    }

    public Collection<ApplicationPermission> findByFeature(ApplicationFeatureId featureId) {
        return (Collection)this.repository.allMatches((Query)new QueryDefault(ApplicationPermission.class, "findByFeature", new Object[]{"featureType", featureId.getType(), "featureFqn", featureId.getFullyQualifiedName()})).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public ApplicationPermission newPermission(ApplicationRole genericRole, ApplicationPermissionRule rule, ApplicationPermissionMode mode, ApplicationFeatureType featureType, String featureFqn) {
        org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole role = (org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole)_Casts.uncheckedCast((Object)genericRole);
        ApplicationFeatureId featureId = ApplicationFeatureId.newFeature((ApplicationFeatureType)featureType, (String)featureFqn);
        ApplicationFeature feature = this.applicationFeatureRepository.findFeature(featureId);
        if (feature == null) {
            this.messages.warnUser("No such " + featureType.name().toLowerCase() + ": " + featureFqn);
            return null;
        }
        return this.newPermissionNoCheck(role, rule, mode, featureType, featureFqn);
    }

    public ApplicationPermission newPermissionNoCheck(org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole role, ApplicationPermissionRule rule, ApplicationPermissionMode mode, ApplicationFeatureType featureType, String featureFqn) {
        ApplicationPermission permission = this.findByRoleAndRuleAndFeature(role, rule, featureType, featureFqn).orElse(null);
        if (permission != null) {
            return permission;
        }
        permission = this.newApplicationPermission();
        permission.setRole(role);
        permission.setRule(rule);
        permission.setMode(mode);
        permission.setFeatureType(featureType);
        permission.setFeatureFqn(featureFqn);
        this.repository.persist((Object)permission);
        return permission;
    }

    public ApplicationPermission newPermission(ApplicationRole genericRole, ApplicationPermissionRule rule, ApplicationPermissionMode mode, String featurePackage, String featureClassName, String featureMemberName) {
        org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole role = (org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole)_Casts.uncheckedCast((Object)genericRole);
        ApplicationFeatureId featureId = ApplicationFeatureId.newFeature((String)featurePackage, (String)featureClassName, (String)featureMemberName);
        ApplicationFeatureType featureType = featureId.getType();
        String featureFqn = featureId.getFullyQualifiedName();
        ApplicationFeature feature = this.applicationFeatureRepository.findFeature(featureId);
        if (feature == null) {
            this.messages.warnUser("No such " + featureType.name().toLowerCase() + ": " + featureFqn);
            return null;
        }
        ApplicationPermission permission = (ApplicationPermission)this.factory.detachedEntity(ApplicationPermission.class);
        permission.setRole(role);
        permission.setRule(rule);
        permission.setMode(mode);
        permission.setFeatureType(featureType);
        permission.setFeatureFqn(featureFqn);
        this.repository.persist((Object)permission);
        return permission;
    }

    public Collection<ApplicationPermission> allPermissions() {
        return (Collection)this.repository.allInstances(ApplicationPermission.class).stream().collect(_Sets.toUnmodifiableSorted());
    }

    public Collection<ApplicationPermission> findOrphaned() {
        SortedSet packageNames = this.applicationFeatureRepository.packageNames();
        TreeSet availableClasses = _Sets.newTreeSet();
        for (String packageName : packageNames) {
            this.appendClasses(packageName, ApplicationMemberType.PROPERTY, availableClasses);
            this.appendClasses(packageName, ApplicationMemberType.COLLECTION, availableClasses);
            this.appendClasses(packageName, ApplicationMemberType.ACTION, availableClasses);
        }
        ArrayList orphaned = _Lists.newArrayList();
        Collection<ApplicationPermission> permissions = this.allPermissions();
        for (ApplicationPermission permission : permissions) {
            ApplicationFeatureType featureType = permission.getFeatureType();
            String featureFqn = permission.getFeatureFqn();
            switch (featureType) {
                case PACKAGE: {
                    if (packageNames.contains(featureFqn)) break;
                    orphaned.add(permission);
                    break;
                }
                case CLASS: {
                    if (availableClasses.contains(featureFqn)) break;
                    orphaned.add(permission);
                    break;
                }
                case MEMBER: {
                    List split = _Strings.splitThenStream((String)featureFqn, (String)"#").collect(Collectors.toList());
                    String fqClassName = (String)split.get(0);
                    String memberName = (String)split.get(1);
                    int lastDot = fqClassName.lastIndexOf(46);
                    String packageName = fqClassName.substring(0, lastDot);
                    String className = fqClassName.substring(lastDot + 1);
                    List<String> memberNames = this.memberNamesOf(packageName, className);
                    if (memberNames.contains(memberName)) break;
                    orphaned.add(permission);
                }
            }
        }
        return orphaned;
    }

    private void appendClasses(String packageName, ApplicationMemberType memberType, Set<String> availableClasses) {
        SortedSet classNames = this.applicationFeatureRepository.classNamesContainedIn(packageName, memberType);
        for (String className : classNames) {
            availableClasses.add(packageName + "." + className);
        }
    }

    private List<String> memberNamesOf(String packageName, String className) {
        ArrayList memberNames = _Lists.newArrayList();
        this.appendMembers(packageName, className, ApplicationMemberType.PROPERTY, memberNames);
        this.appendMembers(packageName, className, ApplicationMemberType.COLLECTION, memberNames);
        this.appendMembers(packageName, className, ApplicationMemberType.ACTION, memberNames);
        return memberNames;
    }

    private void appendMembers(String packageName, String className, ApplicationMemberType applicationMemberType, List<String> memberNames) {
        SortedSet memberNamesOf = this.applicationFeatureRepository.memberNamesOf(packageName, className, applicationMemberType);
        memberNames.addAll(memberNamesOf);
    }
}

