/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.jdo.dom.permission;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.DatastoreIdentity;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import javax.jdo.annotations.Version;
import javax.jdo.annotations.VersionStrategy;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.appfeat.ApplicationMemberType;
import org.apache.isis.applib.util.ObjectContracts;
import org.apache.isis.core.commons.internal.base._Casts;
import org.apache.isis.core.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeature;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureId;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureRepositoryDefault;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermission;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionMode;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionRule;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionValue;
import org.apache.isis.extensions.secman.api.role.ApplicationRole;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;

@PersistenceCapable(identityType=IdentityType.DATASTORE, schema="isissecurity", table="ApplicationPermission")
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@DatastoreIdentity(strategy=IdGeneratorStrategy.NATIVE, column="id")
@Version(strategy=VersionStrategy.VERSION_NUMBER, column="version")
@Queries(value={@Query(name="findByRole", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission WHERE role == :role"), @Query(name="findByUser", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission WHERE (u.roles.contains(role) && u.username == :username) VARIABLES org.apache.isis.extensions.secman.jdo.dom.user.ApplicationUser u"), @Query(name="findByFeature", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission WHERE featureType == :featureType    && featureFqn == :featureFqn"), @Query(name="findByRoleAndRuleAndFeature", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission WHERE role == :role    && rule == :rule    && featureType == :featureType    && featureFqn == :featureFqn "), @Query(name="findByRoleAndRuleAndFeatureType", language="JDOQL", value="SELECT FROM org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission WHERE role == :role    && rule == :rule    && featureType == :featureType ")})
@Uniques(value={@Unique(name="ApplicationPermission_role_feature_rule_UNQ", members={"role", "featureType", "featureFqn", "rule"})})
@DomainObject(objectType="isissecurity.ApplicationPermission")
@DomainObjectLayout(bookmarking=BookmarkPolicy.AS_CHILD)
public class ApplicationPermission
implements org.apache.isis.extensions.secman.api.permission.ApplicationPermission,
Comparable<ApplicationPermission> {
    private static final int TYPICAL_LENGTH_TYPE = 7;
    @Column(name="roleId", allowsNull="false")
    @Property(domainEvent=RoleDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(hidden=Where.REFERENCES_PARENT)
    @MemberOrder(name="Role", sequence="1")
    private org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole role;
    @Column(allowsNull="false")
    @Property(domainEvent=RuleDomainEvent.class, editing=Editing.DISABLED)
    @MemberOrder(name="Permissions", sequence="2")
    private ApplicationPermissionRule rule;
    @Column(allowsNull="false")
    @Property(domainEvent=ModeDomainEvent.class, editing=Editing.DISABLED)
    @MemberOrder(name="Permissions", sequence="3")
    private ApplicationPermissionMode mode;
    @Column(allowsNull="false")
    private ApplicationFeatureType featureType;
    @Column(allowsNull="false")
    @Property(domainEvent=FeatureFqnDomainEvent.class, editing=Editing.DISABLED)
    @MemberOrder(name="Feature", sequence="5.1")
    private String featureFqn;
    private static final ObjectContracts.ObjectContract<ApplicationPermission> contract = ObjectContracts.contract(ApplicationPermission.class).thenUse("role", ApplicationPermission::getRole).thenUse("featureType", ApplicationPermission::getFeatureType).thenUse("featureFqn", ApplicationPermission::getFeatureFqn).thenUse("mode", ApplicationPermission::getMode);
    @Inject
    private ApplicationFeatureRepositoryDefault applicationFeatureRepository;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = ApplicationPermission.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = ApplicationPermission.__dnGetInheritedFieldCount();

    public String title() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getRole().getName()).append(":").append(" ").append(this.getRule().toString()).append(" ").append(this.getMode().toString()).append(" of ");
        this.createFeatureId().ifPresent(featureId -> {
            switch (featureId.getType()) {
                case PACKAGE: {
                    buf.append(this.getFeatureFqn());
                    break;
                }
                case CLASS: {
                    if (this.getFeatureFqn().length() < 30) {
                        buf.append(this.getFeatureFqn());
                        break;
                    }
                    buf.append(featureId.getClassName());
                    break;
                }
                case MEMBER: {
                    buf.append(featureId.getClassName()).append("#").append(featureId.getMemberName());
                }
            }
        });
        return buf.toString();
    }

    public void setRole(ApplicationRole applicationRole) {
        ApplicationPermission.dnSetrole(this, (org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole)_Casts.uncheckedCast((Object)applicationRole));
    }

    private Optional<ApplicationFeatureId> createFeatureId() {
        return Optional.of(this.getFeatureType()).map(featureType -> ApplicationFeatureId.newFeature((ApplicationFeatureType)featureType, (String)this.getFeatureFqn()));
    }

    private Optional<ApplicationFeature> getFeature() {
        return this.createFeatureId().map(featureId -> this.applicationFeatureRepository.findFeature(featureId));
    }

    @Property(domainEvent=TypeDomainEvent.class, editing=Editing.DISABLED)
    @PropertyLayout(typicalLength=7)
    @MemberOrder(name="Feature", sequence="5")
    public String getType() {
        ApplicationFeatureType e = this.getFeatureType() != ApplicationFeatureType.MEMBER ? this.getFeatureType() : (Enum)this.getMemberType().orElse(null);
        return e != null ? e.name() : null;
    }

    @Programmatic
    private Optional<ApplicationMemberType> getMemberType() {
        return this.getFeature().map(ApplicationFeature::getMemberType);
    }

    @Programmatic
    public ApplicationFeatureType getFeatureType() {
        return ApplicationPermission.dnGetfeatureType(this);
    }

    @Override
    public int compareTo(ApplicationPermission other) {
        return contract.compare((Object)this, (Object)other);
    }

    public boolean equals(Object other) {
        return contract.equals((Object)this, other);
    }

    public int hashCode() {
        return contract.hashCode((Object)this);
    }

    public String toString() {
        return contract.toString((Object)this);
    }

    public org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole getRole() {
        return ApplicationPermission.dnGetrole(this);
    }

    public ApplicationPermissionRule getRule() {
        return ApplicationPermission.dnGetrule(this);
    }

    public void setRule(ApplicationPermissionRule rule) {
        ApplicationPermission.dnSetrule(this, rule);
    }

    public ApplicationPermissionMode getMode() {
        return ApplicationPermission.dnGetmode(this);
    }

    public void setMode(ApplicationPermissionMode mode) {
        ApplicationPermission.dnSetmode(this, mode);
    }

    public void setFeatureType(ApplicationFeatureType featureType) {
        ApplicationPermission.dnSetfeatureType(this, featureType);
    }

    public String getFeatureFqn() {
        return ApplicationPermission.dnGetfeatureFqn(this);
    }

    public void setFeatureFqn(String featureFqn) {
        ApplicationPermission.dnSetfeatureFqn(this, featureFqn);
    }

    static {
        EnhancementHelper.registerClass((Class)ApplicationPermission.___dn$loadClass("org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission"), (Persistable)new ApplicationPermission());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return null;
    }

    public Object dnNewObjectIdInstance(Object key) {
        return null;
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        ApplicationPermission result = new ApplicationPermission();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        ApplicationPermission result = new ApplicationPermission();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.featureFqn = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.featureType = (ApplicationFeatureType)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.mode = (ApplicationPermissionMode)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.role = (org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.rule = (ApplicationPermissionRule)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.featureFqn);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.featureType);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.mode);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.role);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.rule);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(ApplicationPermission obj, int index) {
        switch (index) {
            case 0: {
                this.featureFqn = obj.featureFqn;
                break;
            }
            case 1: {
                this.featureType = obj.featureType;
                break;
            }
            case 2: {
                this.mode = obj.mode;
                break;
            }
            case 3: {
                this.role = obj.role;
                break;
            }
            case 4: {
                this.rule = obj.rule;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof ApplicationPermission)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.isis.extensions.secman.jdo.dom.permission.ApplicationPermission");
        }
        ApplicationPermission other = (ApplicationPermission)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"featureFqn", "featureType", "mode", "role", "rule"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 5;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static String dnGetfeatureFqn(ApplicationPermission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.featureFqn);
        }
        return objPC.featureFqn;
    }

    private static void dnSetfeatureFqn(ApplicationPermission objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.featureFqn, val);
        } else {
            objPC.featureFqn = val;
        }
    }

    private static ApplicationFeatureType dnGetfeatureType(ApplicationPermission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return (ApplicationFeatureType)objPC.dnStateManager.getObjectField((Persistable)objPC, 1, (Object)objPC.featureType);
        }
        return objPC.featureType;
    }

    private static void dnSetfeatureType(ApplicationPermission objPC, ApplicationFeatureType val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1, (Object)objPC.featureType, (Object)val);
        } else {
            objPC.featureType = val;
        }
    }

    private static ApplicationPermissionMode dnGetmode(ApplicationPermission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (ApplicationPermissionMode)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, (Object)objPC.mode);
        }
        return objPC.mode;
    }

    private static void dnSetmode(ApplicationPermission objPC, ApplicationPermissionMode val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, (Object)objPC.mode, (Object)val);
        } else {
            objPC.mode = val;
        }
    }

    private static org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole dnGetrole(ApplicationPermission objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return (org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole)objPC.dnStateManager.getObjectField((Persistable)objPC, 3, (Object)objPC.role);
        }
        return objPC.role;
    }

    private static void dnSetrole(ApplicationPermission objPC, org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole val) {
        if (objPC.dnStateManager == null) {
            objPC.role = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, (Object)objPC.role, (Object)val);
        }
    }

    private static ApplicationPermissionRule dnGetrule(ApplicationPermission objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (ApplicationPermissionRule)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, (Object)objPC.rule);
        }
        return objPC.rule;
    }

    private static void dnSetrule(ApplicationPermission objPC, ApplicationPermissionRule val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, (Object)objPC.rule, (Object)val);
        } else {
            objPC.rule = val;
        }
    }

    public static final class Functions {
        public static final Function<ApplicationPermission, ApplicationPermissionValue> AS_VALUE = input -> new ApplicationPermissionValue((ApplicationFeatureId)((ApplicationPermission)input).createFeatureId().orElseThrow(_Exceptions::noSuchElement), input.getRule(), input.getMode());

        private Functions() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static class DefaultComparator
    implements Comparator<ApplicationPermission> {
        @Override
        public int compare(ApplicationPermission o1, ApplicationPermission o2) {
            return Objects.compare(o1, o2, (a, b) -> a.compareTo((ApplicationPermission)b));
        }
    }

    public static class FeatureFqnDomainEvent
    extends ApplicationPermission.PropertyDomainEvent<String> {
    }

    public static class TypeDomainEvent
    extends ApplicationPermission.PropertyDomainEvent<String> {
    }

    public static class ModeDomainEvent
    extends ApplicationPermission.PropertyDomainEvent<ApplicationPermissionMode> {
    }

    public static class RuleDomainEvent
    extends ApplicationPermission.PropertyDomainEvent<ApplicationPermissionRule> {
    }

    public static class RoleDomainEvent
    extends ApplicationPermission.PropertyDomainEvent<org.apache.isis.extensions.secman.jdo.dom.role.ApplicationRole> {
    }
}

