/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.api.user;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.isis.applib.value.Password;
import org.apache.isis.extensions.secman.api.role.ApplicationRole;
import org.apache.isis.extensions.secman.api.tenancy.ApplicationTenancy;
import org.apache.isis.extensions.secman.api.user.AccountType;
import org.apache.isis.extensions.secman.api.user.ApplicationUser;
import org.apache.isis.extensions.secman.api.user.ApplicationUserStatus;

public interface ApplicationUserRepository<U extends ApplicationUser> {
    public U newApplicationUser();

    public Optional<U> findByUsername(String var1);

    public U findOrCreateUserByUsername(String var1);

    public Collection<U> allUsers();

    public Collection<U> find(String var1);

    public Collection<U> findByAtPath(String var1);

    public Collection<U> findByRole(ApplicationRole var1);

    public Collection<U> findByTenancy(ApplicationTenancy var1);

    public Collection<U> findMatching(String var1);

    public void enable(ApplicationUser var1);

    public void disable(ApplicationUser var1);

    public boolean isAdminUser(ApplicationUser var1);

    public boolean isPasswordFeatureEnabled(ApplicationUser var1);

    public boolean updatePassword(ApplicationUser var1, String var2);

    public U newUser(String var1, AccountType var2, Consumer<U> var3);

    default public U newLocalUser(@NonNull String username, @Nullable Password password, @NonNull ApplicationUserStatus status) {
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return (U)this.newUser(username, AccountType.LOCAL, user -> {
            user.setStatus(status);
            if (password != null) {
                this.updatePassword((ApplicationUser)user, password.getPassword());
            }
        });
    }

    default public U newDelegateUser(String username, ApplicationUserStatus status) {
        return (U)this.newUser(username, AccountType.DELEGATED, user -> user.setStatus(status));
    }
}

