/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.api.user;

import java.util.SortedSet;
import org.apache.isis.applib.services.HasUsername;
import org.apache.isis.extensions.secman.api.IsisModuleExtSecmanApi;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionValueSet;
import org.apache.isis.extensions.secman.api.role.ApplicationRole;
import org.apache.isis.extensions.secman.api.tenancy.HasAtPath;
import org.apache.isis.extensions.secman.api.user.AccountType;
import org.apache.isis.extensions.secman.api.user.ApplicationUserStatus;

public interface ApplicationUser
extends HasUsername,
HasAtPath {
    public static final int MAX_LENGTH_USERNAME = 30;
    public static final int MAX_LENGTH_FAMILY_NAME = 50;
    public static final int MAX_LENGTH_GIVEN_NAME = 50;
    public static final int MAX_LENGTH_KNOWN_AS = 20;
    public static final int MAX_LENGTH_EMAIL_ADDRESS = 50;
    public static final int MAX_LENGTH_PHONE_NUMBER = 25;

    default public String title() {
        return this.getName();
    }

    default public String iconName() {
        return this.getStatus().isEnabled() ? "enabled" : "disabled";
    }

    public String getName();

    public String getEncryptedPassword();

    public AccountType getAccountType();

    public void setAccountType(AccountType var1);

    public ApplicationPermissionValueSet getPermissionSet();

    public SortedSet<? extends ApplicationRole> getRoles();

    public ApplicationUserStatus getStatus();

    public void setStatus(ApplicationUserStatus var1);

    public void setAtPath(String var1);

    public String getEmailAddress();

    public void setEmailAddress(String var1);

    public String getFaxNumber();

    public void setFaxNumber(String var1);

    public String getFamilyName();

    public void setFamilyName(String var1);

    public String getGivenName();

    public void setGivenName(String var1);

    public String getKnownAs();

    public void setKnownAs(String var1);

    public String getPhoneNumber();

    public void setPhoneNumber(String var1);

    public void setUsername(String var1);

    public void setEncryptedPassword(String var1);

    public boolean isForSelfOrRunAsAdministrator();

    public boolean isHasPassword();

    default public boolean isLocalAccount() {
        return this.getAccountType() == AccountType.LOCAL;
    }

    public static class UserDuplicateDomainEvent
    extends ActionDomainEvent {
    }

    public static class NewLocalUserDomainEvent
    extends ActionDomainEvent {
    }

    public static class NewDelegateUserDomainEvent
    extends ActionDomainEvent {
    }

    public static class DeleteDomainEvent
    extends ActionDomainEvent {
    }

    public static class RemoveRoleDomainEvent
    extends ActionDomainEvent {
    }

    public static class ResetPasswordDomainEvent
    extends ActionDomainEvent {
    }

    public static class UpdatePasswordDomainEvent
    extends ActionDomainEvent {
    }

    public static class LockDomainEvent
    extends ActionDomainEvent {
    }

    public static class UnlockDomainEvent
    extends ActionDomainEvent {
    }

    public static class UpdateAccountTypeDomainEvent
    extends ActionDomainEvent {
    }

    public static class UpdateFaxNumberDomainEvent
    extends ActionDomainEvent {
    }

    public static class UpdatePhoneNumberDomainEvent
    extends ActionDomainEvent {
    }

    public static class UpdateEmailAddressDomainEvent
    extends ActionDomainEvent {
    }

    public static class UpdateNameDomainEvent
    extends ActionDomainEvent {
    }

    public static class UpdateUsernameDomainEvent
    extends ActionDomainEvent {
    }

    public static class UpdateAtPathDomainEvent
    extends ActionDomainEvent {
    }

    public static class AddRoleDomainEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisModuleExtSecmanApi.ActionDomainEvent<ApplicationUser> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends IsisModuleExtSecmanApi.CollectionDomainEvent<ApplicationUser, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends IsisModuleExtSecmanApi.PropertyDomainEvent<ApplicationUser, T> {
    }
}

