/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.api.permission;

import java.util.Collection;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureId;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionMode;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionValue;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionValueSet;
import org.apache.isis.extensions.secman.api.permission.PermissionsEvaluationService;

public abstract class PermissionsEvaluationServiceAbstract
implements PermissionsEvaluationService {
    private static final long serialVersionUID = 1L;

    @Override
    public ApplicationPermissionValueSet.Evaluation evaluate(ApplicationFeatureId targetMemberId, ApplicationPermissionMode mode, Collection<ApplicationPermissionValue> permissionValues) {
        if (_NullSafe.isEmpty(permissionValues)) {
            return null;
        }
        Collection<ApplicationPermissionValue> ordered = this.ordered(permissionValues);
        for (ApplicationPermissionValue permissionValue : ordered) {
            if (permissionValue.implies(targetMemberId, mode)) {
                return new ApplicationPermissionValueSet.Evaluation(permissionValue, true);
            }
            if (!permissionValue.refutes(targetMemberId, mode)) continue;
            return new ApplicationPermissionValueSet.Evaluation(permissionValue, false);
        }
        return null;
    }

    protected abstract Collection<ApplicationPermissionValue> ordered(Collection<ApplicationPermissionValue> var1);
}

