/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.api.permission;

import java.util.Optional;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureId;
import org.apache.isis.core.metamodel.services.appfeat.ApplicationFeatureType;
import org.apache.isis.extensions.secman.api.IsisModuleExtSecmanApi;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionMode;
import org.apache.isis.extensions.secman.api.permission.ApplicationPermissionRule;
import org.apache.isis.extensions.secman.api.role.ApplicationRole;

public interface ApplicationPermission {
    default public String title() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getRole().getName()).append(":").append(" ").append(this.getRule().toString()).append(" ").append(this.getMode().toString()).append(" of ");
        this.createFeatureId().ifPresent(featureId -> {
            switch (featureId.getType()) {
                case PACKAGE: {
                    buf.append(this.getFeatureFqn());
                    break;
                }
                case CLASS: {
                    if (this.getFeatureFqn().length() < 30) {
                        buf.append(this.getFeatureFqn());
                        break;
                    }
                    buf.append(featureId.getClassName());
                    break;
                }
                case MEMBER: {
                    buf.append(featureId.getClassName()).append("#").append(featureId.getMemberName());
                }
            }
        });
        return buf.toString();
    }

    public ApplicationFeatureType getFeatureType();

    public String getFeatureFqn();

    public ApplicationPermissionRule getRule();

    public void setRule(ApplicationPermissionRule var1);

    public ApplicationPermissionMode getMode();

    public void setMode(ApplicationPermissionMode var1);

    public ApplicationRole getRole();

    public void setRole(ApplicationRole var1);

    @Programmatic
    default public Optional<ApplicationFeatureId> createFeatureId() {
        return Optional.of(this.getFeatureType()).map(featureType -> ApplicationFeatureId.newFeature((ApplicationFeatureType)featureType, (String)this.getFeatureFqn()));
    }

    public static class ViewingDomainEvent
    extends ActionDomainEvent {
    }

    public static class ChangingDomainEvent
    extends ActionDomainEvent {
    }

    public static class DeleteDomainEvent
    extends ActionDomainEvent {
    }

    public static class VetoDomainEvent
    extends ActionDomainEvent {
    }

    public static class UpdateRoleDomainEvent
    extends ActionDomainEvent {
    }

    public static class AllowDomainEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisModuleExtSecmanApi.ActionDomainEvent<ApplicationPermission> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends IsisModuleExtSecmanApi.CollectionDomainEvent<ApplicationPermission, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends IsisModuleExtSecmanApi.PropertyDomainEvent<ApplicationPermission, T> {
    }
}

