/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.secman.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._NullSafe;

public class SecurityModuleConfig {
    @NonNull
    final String regularUserRoleName;
    @NonNull
    final String fixtureRoleName;
    @NonNull
    final String adminRoleName;
    @NonNull
    final String adminUserName;
    @NonNull
    final String adminPassword;
    @NonNull
    final String[] adminStickyPackagePermissions;
    final Set<String> adminAdditionalPackagePermissions;
    final boolean autoEnableIfDelegatedAndAuthenticated;

    public Stream<String> streamAdminPackagePermissions() {
        return Stream.concat(_NullSafe.stream((Object[])this.adminStickyPackagePermissions), _NullSafe.stream(this.adminAdditionalPackagePermissions));
    }

    public boolean isStickyAdminPackage(String featureFqn) {
        return _NullSafe.stream((Object[])this.adminStickyPackagePermissions).anyMatch(stickyPackage -> stickyPackage.equals(featureFqn));
    }

    private static String $default$regularUserRoleName() {
        return "isis-module-security-regular-user";
    }

    private static String $default$fixtureRoleName() {
        return "isis-module-security-fixtures";
    }

    private static String $default$adminRoleName() {
        return "isis-module-security-admin";
    }

    private static String $default$adminUserName() {
        return "isis-module-security-admin";
    }

    private static String $default$adminPassword() {
        return "pass";
    }

    private static String[] $default$adminStickyPackagePermissions() {
        return new String[]{"org.apache.isis.extensions.secman.api", "org.apache.isis.extensions.secman.model", "org.apache.isis.extensions.secman.jdo.dom"};
    }

    private static boolean $default$autoEnableIfDelegatedAndAuthenticated() {
        return false;
    }

    SecurityModuleConfig(@NonNull String regularUserRoleName, @NonNull String fixtureRoleName, @NonNull String adminRoleName, @NonNull String adminUserName, @NonNull String adminPassword, @NonNull String[] adminStickyPackagePermissions, Set<String> adminAdditionalPackagePermissions, boolean autoEnableIfDelegatedAndAuthenticated) {
        if (regularUserRoleName == null) {
            throw new NullPointerException("regularUserRoleName is marked non-null but is null");
        }
        if (fixtureRoleName == null) {
            throw new NullPointerException("fixtureRoleName is marked non-null but is null");
        }
        if (adminRoleName == null) {
            throw new NullPointerException("adminRoleName is marked non-null but is null");
        }
        if (adminUserName == null) {
            throw new NullPointerException("adminUserName is marked non-null but is null");
        }
        if (adminPassword == null) {
            throw new NullPointerException("adminPassword is marked non-null but is null");
        }
        if (adminStickyPackagePermissions == null) {
            throw new NullPointerException("adminStickyPackagePermissions is marked non-null but is null");
        }
        this.regularUserRoleName = regularUserRoleName;
        this.fixtureRoleName = fixtureRoleName;
        this.adminRoleName = adminRoleName;
        this.adminUserName = adminUserName;
        this.adminPassword = adminPassword;
        this.adminStickyPackagePermissions = adminStickyPackagePermissions;
        this.adminAdditionalPackagePermissions = adminAdditionalPackagePermissions;
        this.autoEnableIfDelegatedAndAuthenticated = autoEnableIfDelegatedAndAuthenticated;
    }

    public static SecurityModuleConfigBuilder builder() {
        return new SecurityModuleConfigBuilder();
    }

    @NonNull
    public String getRegularUserRoleName() {
        return this.regularUserRoleName;
    }

    @NonNull
    public String getFixtureRoleName() {
        return this.fixtureRoleName;
    }

    @NonNull
    public String getAdminRoleName() {
        return this.adminRoleName;
    }

    @NonNull
    public String getAdminUserName() {
        return this.adminUserName;
    }

    @NonNull
    public String getAdminPassword() {
        return this.adminPassword;
    }

    @NonNull
    public String[] getAdminStickyPackagePermissions() {
        return this.adminStickyPackagePermissions;
    }

    public Set<String> getAdminAdditionalPackagePermissions() {
        return this.adminAdditionalPackagePermissions;
    }

    public boolean isAutoEnableIfDelegatedAndAuthenticated() {
        return this.autoEnableIfDelegatedAndAuthenticated;
    }

    public static class SecurityModuleConfigBuilder {
        private boolean regularUserRoleName$set;
        private String regularUserRoleName$value;
        private boolean fixtureRoleName$set;
        private String fixtureRoleName$value;
        private boolean adminRoleName$set;
        private String adminRoleName$value;
        private boolean adminUserName$set;
        private String adminUserName$value;
        private boolean adminPassword$set;
        private String adminPassword$value;
        private boolean adminStickyPackagePermissions$set;
        private String[] adminStickyPackagePermissions$value;
        private ArrayList<String> adminAdditionalPackagePermissions;
        private boolean autoEnableIfDelegatedAndAuthenticated$set;
        private boolean autoEnableIfDelegatedAndAuthenticated$value;

        SecurityModuleConfigBuilder() {
        }

        public SecurityModuleConfigBuilder regularUserRoleName(@NonNull String regularUserRoleName) {
            if (regularUserRoleName == null) {
                throw new NullPointerException("regularUserRoleName is marked non-null but is null");
            }
            this.regularUserRoleName$value = regularUserRoleName;
            this.regularUserRoleName$set = true;
            return this;
        }

        public SecurityModuleConfigBuilder fixtureRoleName(@NonNull String fixtureRoleName) {
            if (fixtureRoleName == null) {
                throw new NullPointerException("fixtureRoleName is marked non-null but is null");
            }
            this.fixtureRoleName$value = fixtureRoleName;
            this.fixtureRoleName$set = true;
            return this;
        }

        public SecurityModuleConfigBuilder adminRoleName(@NonNull String adminRoleName) {
            if (adminRoleName == null) {
                throw new NullPointerException("adminRoleName is marked non-null but is null");
            }
            this.adminRoleName$value = adminRoleName;
            this.adminRoleName$set = true;
            return this;
        }

        public SecurityModuleConfigBuilder adminUserName(@NonNull String adminUserName) {
            if (adminUserName == null) {
                throw new NullPointerException("adminUserName is marked non-null but is null");
            }
            this.adminUserName$value = adminUserName;
            this.adminUserName$set = true;
            return this;
        }

        public SecurityModuleConfigBuilder adminPassword(@NonNull String adminPassword) {
            if (adminPassword == null) {
                throw new NullPointerException("adminPassword is marked non-null but is null");
            }
            this.adminPassword$value = adminPassword;
            this.adminPassword$set = true;
            return this;
        }

        public SecurityModuleConfigBuilder adminStickyPackagePermissions(@NonNull String[] adminStickyPackagePermissions) {
            if (adminStickyPackagePermissions == null) {
                throw new NullPointerException("adminStickyPackagePermissions is marked non-null but is null");
            }
            this.adminStickyPackagePermissions$value = adminStickyPackagePermissions;
            this.adminStickyPackagePermissions$set = true;
            return this;
        }

        public SecurityModuleConfigBuilder adminAdditionalPackagePermission(String adminAdditionalPackagePermission) {
            if (this.adminAdditionalPackagePermissions == null) {
                this.adminAdditionalPackagePermissions = new ArrayList();
            }
            this.adminAdditionalPackagePermissions.add(adminAdditionalPackagePermission);
            return this;
        }

        public SecurityModuleConfigBuilder adminAdditionalPackagePermissions(Collection<? extends String> adminAdditionalPackagePermissions) {
            if (adminAdditionalPackagePermissions == null) {
                throw new NullPointerException("adminAdditionalPackagePermissions cannot be null");
            }
            if (this.adminAdditionalPackagePermissions == null) {
                this.adminAdditionalPackagePermissions = new ArrayList();
            }
            this.adminAdditionalPackagePermissions.addAll(adminAdditionalPackagePermissions);
            return this;
        }

        public SecurityModuleConfigBuilder clearAdminAdditionalPackagePermissions() {
            if (this.adminAdditionalPackagePermissions != null) {
                this.adminAdditionalPackagePermissions.clear();
            }
            return this;
        }

        public SecurityModuleConfigBuilder autoEnableIfDelegatedAndAuthenticated(boolean autoEnableIfDelegatedAndAuthenticated) {
            this.autoEnableIfDelegatedAndAuthenticated$value = autoEnableIfDelegatedAndAuthenticated;
            this.autoEnableIfDelegatedAndAuthenticated$set = true;
            return this;
        }

        public SecurityModuleConfig build() {
            Set<Object> adminAdditionalPackagePermissions;
            switch (this.adminAdditionalPackagePermissions == null ? 0 : this.adminAdditionalPackagePermissions.size()) {
                case 0: {
                    adminAdditionalPackagePermissions = Collections.emptySet();
                    break;
                }
                case 1: {
                    adminAdditionalPackagePermissions = Collections.singleton(this.adminAdditionalPackagePermissions.get(0));
                    break;
                }
                default: {
                    adminAdditionalPackagePermissions = new LinkedHashSet(this.adminAdditionalPackagePermissions.size() < 0x40000000 ? 1 + this.adminAdditionalPackagePermissions.size() + (this.adminAdditionalPackagePermissions.size() - 3) / 3 : Integer.MAX_VALUE);
                    adminAdditionalPackagePermissions.addAll(this.adminAdditionalPackagePermissions);
                    adminAdditionalPackagePermissions = Collections.unmodifiableSet(adminAdditionalPackagePermissions);
                }
            }
            String regularUserRoleName$value = this.regularUserRoleName$value;
            if (!this.regularUserRoleName$set) {
                regularUserRoleName$value = SecurityModuleConfig.$default$regularUserRoleName();
            }
            String fixtureRoleName$value = this.fixtureRoleName$value;
            if (!this.fixtureRoleName$set) {
                fixtureRoleName$value = SecurityModuleConfig.$default$fixtureRoleName();
            }
            String adminRoleName$value = this.adminRoleName$value;
            if (!this.adminRoleName$set) {
                adminRoleName$value = SecurityModuleConfig.$default$adminRoleName();
            }
            String adminUserName$value = this.adminUserName$value;
            if (!this.adminUserName$set) {
                adminUserName$value = SecurityModuleConfig.$default$adminUserName();
            }
            String adminPassword$value = this.adminPassword$value;
            if (!this.adminPassword$set) {
                adminPassword$value = SecurityModuleConfig.$default$adminPassword();
            }
            String[] adminStickyPackagePermissions$value = this.adminStickyPackagePermissions$value;
            if (!this.adminStickyPackagePermissions$set) {
                adminStickyPackagePermissions$value = SecurityModuleConfig.$default$adminStickyPackagePermissions();
            }
            boolean autoEnableIfDelegatedAndAuthenticated$value = this.autoEnableIfDelegatedAndAuthenticated$value;
            if (!this.autoEnableIfDelegatedAndAuthenticated$set) {
                autoEnableIfDelegatedAndAuthenticated$value = SecurityModuleConfig.$default$autoEnableIfDelegatedAndAuthenticated();
            }
            return new SecurityModuleConfig(regularUserRoleName$value, fixtureRoleName$value, adminRoleName$value, adminUserName$value, adminPassword$value, adminStickyPackagePermissions$value, adminAdditionalPackagePermissions, autoEnableIfDelegatedAndAuthenticated$value);
        }

        public String toString() {
            return "SecurityModuleConfig.SecurityModuleConfigBuilder(regularUserRoleName$value=" + this.regularUserRoleName$value + ", fixtureRoleName$value=" + this.fixtureRoleName$value + ", adminRoleName$value=" + this.adminRoleName$value + ", adminUserName$value=" + this.adminUserName$value + ", adminPassword$value=" + this.adminPassword$value + ", adminStickyPackagePermissions$value=" + Arrays.deepToString(this.adminStickyPackagePermissions$value) + ", adminAdditionalPackagePermissions=" + this.adminAdditionalPackagePermissions + ", autoEnableIfDelegatedAndAuthenticated$value=" + this.autoEnableIfDelegatedAndAuthenticated$value + ")";
        }
    }
}

