/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.pdfjs.wkt.integration.components;

import lombok.NonNull;
import org.apache.isis.extensions.pdfjs.applib.config.PdfJsConfig;
import org.apache.isis.extensions.pdfjs.wkt.integration.res.PdfJsCmapsReference;
import org.apache.isis.extensions.pdfjs.wkt.integration.res.PdfJsIntegrationReference;
import org.apache.isis.extensions.pdfjs.wkt.integration.res.PdfJsReference;
import org.apache.isis.extensions.pdfjs.wkt.integration.res.PdfJsWorkerReference;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.panel.Panel;

public class PdfJsPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ID_PDFJSCANVAS = "pdfJsCanvas";
    private PdfJsConfig config;

    public PdfJsPanel(String id, @NonNull PdfJsConfig config) {
        super(id);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        WebComponent pdfJsCanvas = (WebComponent)Wkt.add((MarkupContainer)this, (Component)((WebComponent)Wkt.ajaxEnable((Component)new WebComponent(ID_PDFJSCANVAS))));
        this.config = config.withWorkerUrl((CharSequence)PdfJsWorkerReference.workerUrl()).withCmapsUrl((CharSequence)PdfJsCmapsReference.cmapsUrl()).withCanvasId((CharSequence)pdfJsCanvas.getMarkupId());
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render(PdfJsReference.asHeaderItem());
        response.render(PdfJsIntegrationReference.asHeaderItem());
        response.render((HeaderItem)PdfJsIntegrationReference.domReadyScript(this.config));
    }

    public CharSequence getCanvasId() {
        return this.config.getCanvasId();
    }
}

