/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.pdfjs.applib.spi;

import java.io.Serializable;
import javax.annotation.Priority;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.extensions.pdfjs.applib.config.Scale;
import org.springframework.stereotype.Service;

public interface PdfJsViewerAdvisor {
    public Advice advise(InstanceKey var1);

    public void pageNumChangedTo(InstanceKey var1, int var2);

    public void scaleChangedTo(InstanceKey var1, Scale var2);

    public void heightChangedTo(InstanceKey var1, int var2);

    @Service
    @Priority(value=0x5FFFFFFF)
    public static class Default
    implements PdfJsViewerAdvisor {
        @Override
        public Advice advise(InstanceKey instanceKey) {
            return new Advice(1, Scale._0_75, 800);
        }

        @Override
        public void pageNumChangedTo(InstanceKey instanceKey, int pageNum) {
        }

        @Override
        public void scaleChangedTo(InstanceKey instanceKey, Scale scale) {
        }

        @Override
        public void heightChangedTo(InstanceKey instanceKey, int height) {
        }
    }

    @Programmatic
    public static final class Advice
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Integer pageNum;
        private final Scale scale;
        private final Integer height;

        public Advice(Integer pageNum, Scale scale, Integer height) {
            this.pageNum = pageNum;
            this.scale = scale;
            this.height = height;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public Scale getScale() {
            return this.scale;
        }

        public Integer getHeight() {
            return this.height;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Advice)) {
                return false;
            }
            Advice other = (Advice)o;
            Integer this$pageNum = this.getPageNum();
            Integer other$pageNum = other.getPageNum();
            if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
                return false;
            }
            Integer this$height = this.getHeight();
            Integer other$height = other.getHeight();
            if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                return false;
            }
            Scale this$scale = this.getScale();
            Scale other$scale = other.getScale();
            return !(this$scale == null ? other$scale != null : !((Object)((Object)this$scale)).equals((Object)other$scale));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $pageNum = this.getPageNum();
            result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
            Integer $height = this.getHeight();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            Scale $scale = this.getScale();
            result = result * 59 + ($scale == null ? 43 : ((Object)((Object)$scale)).hashCode());
            return result;
        }

        public String toString() {
            return "PdfJsViewerAdvisor.Advice(pageNum=" + this.getPageNum() + ", scale=" + this.getScale() + ", height=" + this.getHeight() + ")";
        }

        public Advice withPageNum(Integer pageNum) {
            return this.pageNum == pageNum ? this : new Advice(pageNum, this.scale, this.height);
        }

        public Advice withScale(Scale scale) {
            return this.scale == scale ? this : new Advice(this.pageNum, scale, this.height);
        }

        public Advice withHeight(Integer height) {
            return this.height == height ? this : new Advice(this.pageNum, this.scale, height);
        }
    }

    @Programmatic
    public static final class InstanceKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final TypeKey typeKey;
        private final String identifier;

        public InstanceKey(String logicalTypeName, String identifier, String propertyId, String userName) {
            this(new TypeKey(logicalTypeName, propertyId, userName), identifier);
        }

        public Bookmark asBookmark() {
            return Bookmark.forLogicalTypeNameAndIdentifier((String)this.typeKey.logicalTypeName, (String)this.identifier);
        }

        public TypeKey getTypeKey() {
            return this.typeKey;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceKey)) {
                return false;
            }
            InstanceKey other = (InstanceKey)o;
            TypeKey this$typeKey = this.getTypeKey();
            TypeKey other$typeKey = other.getTypeKey();
            if (this$typeKey == null ? other$typeKey != null : !((Object)this$typeKey).equals(other$typeKey)) {
                return false;
            }
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeKey $typeKey = this.getTypeKey();
            result = result * 59 + ($typeKey == null ? 43 : ((Object)$typeKey).hashCode());
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            return result;
        }

        public String toString() {
            return "PdfJsViewerAdvisor.InstanceKey(typeKey=" + this.getTypeKey() + ", identifier=" + this.getIdentifier() + ")";
        }

        public InstanceKey(TypeKey typeKey, String identifier) {
            this.typeKey = typeKey;
            this.identifier = identifier;
        }

        @Programmatic
        public static final class TypeKey
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final String logicalTypeName;
            private final String propertyId;
            private final String userName;

            public TypeKey(String logicalTypeName, String propertyId, String userName) {
                this.logicalTypeName = logicalTypeName;
                this.propertyId = propertyId;
                this.userName = userName;
            }

            public String getLogicalTypeName() {
                return this.logicalTypeName;
            }

            public String getPropertyId() {
                return this.propertyId;
            }

            public String getUserName() {
                return this.userName;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TypeKey)) {
                    return false;
                }
                TypeKey other = (TypeKey)o;
                String this$logicalTypeName = this.getLogicalTypeName();
                String other$logicalTypeName = other.getLogicalTypeName();
                if (this$logicalTypeName == null ? other$logicalTypeName != null : !this$logicalTypeName.equals(other$logicalTypeName)) {
                    return false;
                }
                String this$propertyId = this.getPropertyId();
                String other$propertyId = other.getPropertyId();
                if (this$propertyId == null ? other$propertyId != null : !this$propertyId.equals(other$propertyId)) {
                    return false;
                }
                String this$userName = this.getUserName();
                String other$userName = other.getUserName();
                return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $logicalTypeName = this.getLogicalTypeName();
                result = result * 59 + ($logicalTypeName == null ? 43 : $logicalTypeName.hashCode());
                String $propertyId = this.getPropertyId();
                result = result * 59 + ($propertyId == null ? 43 : $propertyId.hashCode());
                String $userName = this.getUserName();
                result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
                return result;
            }

            public String toString() {
                return "PdfJsViewerAdvisor.InstanceKey.TypeKey(logicalTypeName=" + this.getLogicalTypeName() + ", propertyId=" + this.getPropertyId() + ", userName=" + this.getUserName() + ")";
            }

            public TypeKey withLogicalTypeName(String logicalTypeName) {
                return this.logicalTypeName == logicalTypeName ? this : new TypeKey(logicalTypeName, this.propertyId, this.userName);
            }

            public TypeKey withPropertyId(String propertyId) {
                return this.propertyId == propertyId ? this : new TypeKey(this.logicalTypeName, propertyId, this.userName);
            }

            public TypeKey withUserName(String userName) {
                return this.userName == userName ? this : new TypeKey(this.logicalTypeName, this.propertyId, userName);
            }
        }
    }
}

