/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.pdfjs.applib.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

public enum Scale {
    AUTOMATIC("auto"),
    ACTUAL_SIZE("page-actual"),
    PAGE_FIT("page-fit"),
    PAGE_WIDTH("page-width"),
    _0_50("0.50"),
    _0_75("0.75"),
    _1_00("1.00"),
    _1_25("1.25"),
    _1_50("1.50"),
    _2_00("2.00"),
    _3_00("3.00"),
    _4_00("4.00");

    @JsonValue
    private final String value;

    public static Scale forValue(String scaleValue) {
        if (scaleValue == null) {
            return null;
        }
        for (Scale scale : Scale.values()) {
            if (!Objects.equals(scale.value, scaleValue)) continue;
            return scale;
        }
        return null;
    }

    private Scale(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

