/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.pdfjs.applib.config;

import java.io.Serializable;
import org.apache.isis.commons.internal.resources._Json;
import org.apache.isis.extensions.pdfjs.applib.config.Scale;
import org.springframework.util.Assert;

public class PdfJsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int initialPage;
    private Scale initialScale;
    private int initialHeight;
    private CharSequence documentUrl;
    private CharSequence workerUrl;
    private CharSequence cmapsUrl;
    private CharSequence canvasId;

    public PdfJsConfig withInitialPage(int initialPage) {
        if (initialPage < 1) {
            initialPage = 1;
        }
        return this.asBuilder().initialPage(initialPage).build();
    }

    public PdfJsConfig withInitialHeight(int initialHeight) {
        Assert.isTrue((initialHeight >= 400 && initialHeight <= 2000 ? 1 : 0) != 0, () -> String.format("'initialHeight' must be between 400 and 2000; got %d", initialHeight));
        return this.asBuilder().initialHeight(initialHeight).build();
    }

    public PdfJsConfigBuilder asBuilder() {
        return PdfJsConfig.builder().canvasId(this.getCanvasId()).documentUrl(this.getDocumentUrl()).initialHeight(this.getInitialHeight()).initialPage(this.getInitialPage()).initialScale(this.getInitialScale()).workerUrl(this.getWorkerUrl()).cmapsUrl(this.getCmapsUrl());
    }

    public String toJsonString() {
        return _Json.toString((Object)this, (_Json.JsonCustomizer[])new _Json.JsonCustomizer[0]);
    }

    private static int $default$initialPage() {
        return 1;
    }

    private static Scale $default$initialScale() {
        return Scale._1_00;
    }

    private static int $default$initialHeight() {
        return 800;
    }

    public static PdfJsConfigBuilder builder() {
        return new PdfJsConfigBuilder();
    }

    public int getInitialPage() {
        return this.initialPage;
    }

    public Scale getInitialScale() {
        return this.initialScale;
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    public CharSequence getDocumentUrl() {
        return this.documentUrl;
    }

    public CharSequence getWorkerUrl() {
        return this.workerUrl;
    }

    public CharSequence getCmapsUrl() {
        return this.cmapsUrl;
    }

    public CharSequence getCanvasId() {
        return this.canvasId;
    }

    public PdfJsConfig(int initialPage, Scale initialScale, int initialHeight, CharSequence documentUrl, CharSequence workerUrl, CharSequence cmapsUrl, CharSequence canvasId) {
        this.initialPage = initialPage;
        this.initialScale = initialScale;
        this.initialHeight = initialHeight;
        this.documentUrl = documentUrl;
        this.workerUrl = workerUrl;
        this.cmapsUrl = cmapsUrl;
        this.canvasId = canvasId;
    }

    public PdfJsConfig() {
        this.initialPage = PdfJsConfig.$default$initialPage();
        this.initialScale = PdfJsConfig.$default$initialScale();
        this.initialHeight = PdfJsConfig.$default$initialHeight();
    }

    public PdfJsConfig withInitialScale(Scale initialScale) {
        return this.initialScale == initialScale ? this : new PdfJsConfig(this.initialPage, initialScale, this.initialHeight, this.documentUrl, this.workerUrl, this.cmapsUrl, this.canvasId);
    }

    public PdfJsConfig withDocumentUrl(CharSequence documentUrl) {
        return this.documentUrl == documentUrl ? this : new PdfJsConfig(this.initialPage, this.initialScale, this.initialHeight, documentUrl, this.workerUrl, this.cmapsUrl, this.canvasId);
    }

    public PdfJsConfig withWorkerUrl(CharSequence workerUrl) {
        return this.workerUrl == workerUrl ? this : new PdfJsConfig(this.initialPage, this.initialScale, this.initialHeight, this.documentUrl, workerUrl, this.cmapsUrl, this.canvasId);
    }

    public PdfJsConfig withCmapsUrl(CharSequence cmapsUrl) {
        return this.cmapsUrl == cmapsUrl ? this : new PdfJsConfig(this.initialPage, this.initialScale, this.initialHeight, this.documentUrl, this.workerUrl, cmapsUrl, this.canvasId);
    }

    public PdfJsConfig withCanvasId(CharSequence canvasId) {
        return this.canvasId == canvasId ? this : new PdfJsConfig(this.initialPage, this.initialScale, this.initialHeight, this.documentUrl, this.workerUrl, this.cmapsUrl, canvasId);
    }

    public static class PdfJsConfigBuilder {
        private boolean initialPage$set;
        private int initialPage$value;
        private boolean initialScale$set;
        private Scale initialScale$value;
        private boolean initialHeight$set;
        private int initialHeight$value;
        private CharSequence documentUrl;
        private CharSequence workerUrl;
        private CharSequence cmapsUrl;
        private CharSequence canvasId;

        PdfJsConfigBuilder() {
        }

        public PdfJsConfigBuilder initialPage(int initialPage) {
            this.initialPage$value = initialPage;
            this.initialPage$set = true;
            return this;
        }

        public PdfJsConfigBuilder initialScale(Scale initialScale) {
            this.initialScale$value = initialScale;
            this.initialScale$set = true;
            return this;
        }

        public PdfJsConfigBuilder initialHeight(int initialHeight) {
            this.initialHeight$value = initialHeight;
            this.initialHeight$set = true;
            return this;
        }

        public PdfJsConfigBuilder documentUrl(CharSequence documentUrl) {
            this.documentUrl = documentUrl;
            return this;
        }

        public PdfJsConfigBuilder workerUrl(CharSequence workerUrl) {
            this.workerUrl = workerUrl;
            return this;
        }

        public PdfJsConfigBuilder cmapsUrl(CharSequence cmapsUrl) {
            this.cmapsUrl = cmapsUrl;
            return this;
        }

        public PdfJsConfigBuilder canvasId(CharSequence canvasId) {
            this.canvasId = canvasId;
            return this;
        }

        public PdfJsConfig build() {
            int initialPage$value = this.initialPage$value;
            if (!this.initialPage$set) {
                initialPage$value = PdfJsConfig.$default$initialPage();
            }
            Scale initialScale$value = this.initialScale$value;
            if (!this.initialScale$set) {
                initialScale$value = PdfJsConfig.$default$initialScale();
            }
            int initialHeight$value = this.initialHeight$value;
            if (!this.initialHeight$set) {
                initialHeight$value = PdfJsConfig.$default$initialHeight();
            }
            return new PdfJsConfig(initialPage$value, initialScale$value, initialHeight$value, this.documentUrl, this.workerUrl, this.cmapsUrl, this.canvasId);
        }

        public String toString() {
            return "PdfJsConfig.PdfJsConfigBuilder(initialPage$value=" + this.initialPage$value + ", initialScale$value=" + this.initialScale$value + ", initialHeight$value=" + this.initialHeight$value + ", documentUrl=" + this.documentUrl + ", workerUrl=" + this.workerUrl + ", cmapsUrl=" + this.cmapsUrl + ", canvasId=" + this.canvasId + ")";
        }
    }
}

