/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.executionoutbox.restclient.api;

import java.net.URI;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.isis.extensions.executionoutbox.restclient.api.Jsonable;
import org.apache.isis.extensions.executionoutbox.restclient.api._Jaxb;
import org.apache.isis.extensions.executionoutbox.restclient.api.delete.DeleteMessage;
import org.apache.isis.extensions.executionoutbox.restclient.api.deleteMany.DeleteManyMessage;
import org.apache.isis.schema.common.v2.InteractionType;
import org.apache.isis.schema.ixn.v2.ActionInvocationDto;
import org.apache.isis.schema.ixn.v2.InteractionDto;
import org.apache.isis.schema.ixn.v2.InteractionsDto;
import org.apache.isis.schema.ixn.v2.MemberExecutionDto;
import org.apache.isis.schema.ixn.v2.PropertyEditDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboxClient {
    private static final Logger log = LoggerFactory.getLogger(OutboxClient.class);
    private final ClientBuilder clientBuilder = ClientBuilder.newBuilder();
    private UriBuilder pendingUriBuilder;
    private UriBuilder deleteUriBuilder;
    private UriBuilder deleteManyUriBuilder;
    private String base;
    private String username;
    private String password;

    public OutboxClient() {
    }

    public OutboxClient(String base, String username, String password) {
        this();
        this.setBase(base);
        this.setUsername(username);
        this.setPassword(password);
        this.init();
    }

    public OutboxClient withConnectTimeoutInSecs(int connectTimeoutInSecs) {
        this.clientBuilder.connectTimeout((long)connectTimeoutInSecs, TimeUnit.SECONDS);
        return this;
    }

    public OutboxClient withReadTimeoutInSecs(int readTimeoutInSecs) {
        this.clientBuilder.readTimeout((long)readTimeoutInSecs, TimeUnit.SECONDS);
        return this;
    }

    public void init() {
        this.pendingUriBuilder = UriBuilder.fromUri((String)(this.base + "services/isis.ext.executionOutbox.OutboxRestApi/actions/pending/invoke"));
        this.deleteUriBuilder = UriBuilder.fromUri((String)(this.base + "services/isis.ext.executionOutbox.OutboxRestApi/actions/delete/invoke"));
        this.deleteManyUriBuilder = UriBuilder.fromUri((String)(this.base + "services/isis.ext.executionOutbox.OutboxRestApi/actions/deleteMany/invoke"));
    }

    private void ensureInitialized() {
        if (this.username == null || this.password == null || this.base == null) {
            throw new IllegalStateException("Must initialize 'username', 'password' and 'base' properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InteractionDto> pending() {
        this.ensureInitialized();
        URI uri = this.pendingUriBuilder.build(new Object[0]);
        Client client = null;
        try {
            client = this.clientBuilder.build();
            WebTarget webTarget = client.target(uri);
            Invocation.Builder invocationBuilder = webTarget.request().header("Authorization", (Object)("Basic " + OutboxClient.encode(this.username, this.password))).accept(new MediaType[]{OutboxClient.mediaTypeFor(InteractionsDto.class)});
            Invocation invocation = invocationBuilder.buildGet();
            Response response = invocation.invoke();
            int responseStatus = response.getStatus();
            if (responseStatus != 200) {
                log.warn(invocation.toString());
            }
            InteractionsDto interactionsDto = (InteractionsDto)response.readEntity(InteractionsDto.class);
            List list = interactionsDto.getInteractionDto();
            return list;
        }
        catch (Exception ex) {
            log.error(String.format("Failed to GET from %s", uri.toString()), (Throwable)ex);
        }
        finally {
            OutboxClient.closeQuietly(client);
        }
        return Collections.emptyList();
    }

    private static MediaType mediaTypeFor(Class<?> dtoClass) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("profile", "urn:org.restfulobjects:repr-types/action-result");
        headers.put("x-ro-domain-type", dtoClass.getName());
        return new MediaType("application", "xml", headers);
    }

    public void delete(String interactionId, int sequence) {
        DeleteMessage jsonable = new DeleteMessage(interactionId, sequence);
        this.invoke(jsonable, this.deleteUriBuilder);
    }

    public void deleteMany(List<InteractionDto> interactionDtos) {
        InteractionsDto interactionsDto = new InteractionsDto();
        interactionDtos.forEach(interactionDto -> this.addTo(interactionsDto, (InteractionDto)interactionDto));
        DeleteManyMessage jsonable = new DeleteManyMessage(_Jaxb.toXml(interactionsDto));
        this.invoke(jsonable, this.deleteManyUriBuilder);
    }

    private void addTo(InteractionsDto interactionsDto, InteractionDto orig) {
        InteractionDto copy = new InteractionDto();
        copy.setInteractionId(orig.getInteractionId());
        this.setMemberExecution(copy, orig);
        interactionsDto.getInteractionDto().add(copy);
    }

    private void setMemberExecution(InteractionDto copy, InteractionDto orig) {
        MemberExecutionDto memberExecutionDto = this.newMemberExecutionDto(orig);
        memberExecutionDto.setSequence(orig.getExecution().getSequence());
        copy.setExecution(memberExecutionDto);
    }

    private MemberExecutionDto newMemberExecutionDto(InteractionDto orig) {
        MemberExecutionDto execution = orig.getExecution();
        return execution.getInteractionType() == InteractionType.ACTION_INVOCATION ? new ActionInvocationDto() : new PropertyEditDto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(Jsonable entity, UriBuilder uriBuilder) {
        this.ensureInitialized();
        String json = entity.asJson();
        Client client = null;
        try {
            client = this.clientBuilder.build();
            WebTarget webTarget = client.target(uriBuilder.build(new Object[0]));
            Invocation.Builder invocationBuilder = webTarget.request();
            invocationBuilder.header("Authorization", (Object)("Basic " + OutboxClient.encode(this.username, this.password)));
            Invocation invocation = invocationBuilder.buildPut(Entity.entity((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE));
            Response response = invocation.invoke();
            int responseStatus = response.getStatus();
            if (responseStatus != 200) {
                log.warn(entity.toString());
            }
        }
        catch (Exception ex) {
            log.error(entity.toString(), (Throwable)ex);
        }
        finally {
            OutboxClient.closeQuietly(client);
        }
    }

    private static String encode(String username, String password) {
        return Base64.getEncoder().encodeToString(OutboxClient.asBytes(username, password));
    }

    private static byte[] asBytes(String username, String password) {
        return String.format("%s:%s", username, password).getBytes();
    }

    private static void closeQuietly(Client client) {
        if (client == null) {
            return;
        }
        try {
            client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

