/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.extensions.executionoutbox.restclient.integtests;

import javax.inject.Inject;
import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.core.config.RestEasyConfiguration;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.extensions.executionoutbox.restclient.api.OutboxClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class RestEndpointService {
    private static final Logger log = LogManager.getLogger(RestEndpointService.class);
    private final Environment environment;
    private final RestEasyConfiguration restEasyConfiguration;
    private final WebAppContextPath webAppContextPath;
    private final InteractionService interactionService;

    public OutboxClient newClient(int port, String username, String password) {
        String restRootPath = String.format("http://localhost:%d%s/", port, this.webAppContextPath.prependContextPath(this.restEasyConfiguration.getJaxrs().getDefaultPath()));
        return new OutboxClient(restRootPath, username, password);
    }

    @Inject
    public RestEndpointService(Environment environment, RestEasyConfiguration restEasyConfiguration, WebAppContextPath webAppContextPath, InteractionService interactionService) {
        this.environment = environment;
        this.restEasyConfiguration = restEasyConfiguration;
        this.webAppContextPath = webAppContextPath;
        this.interactionService = interactionService;
    }
}

